/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class ResetWorldAction
extends AbstractAction
implements SimulationListener {
    private Simulation simulation;
    private static ResetWorldAction instance = new ResetWorldAction();
    private static final String iconFile = "reset.png";
    public static final String RESET_WORLD = "resetWorld";

    public static ResetWorldAction getInstance() {
        return instance;
    }

    private ResetWorldAction() {
        super(Config.getString("reset.world"), new ImageIcon(ResetWorldAction.class.getClassLoader().getResource(iconFile)));
    }

    public void attachSimulation(Simulation simulation) {
        this.simulation = simulation;
        simulation.addSimulationListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.simulation == null) {
            Debug.reportError((String)"attempt to reset a simulation while none exists.");
        } else {
            this.resetWorld();
        }
    }

    private void resetWorld() {
        this.simulation.setEnabled(false);
        WorldHandler.getInstance().discardWorld();
        WorldHandler.getInstance().instantiateNewWorld();
    }

    @Override
    public void simulationChanged(final SimulationEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int eventType = e.getType();
                if (eventType == 1) {
                    ResetWorldAction.this.setEnabled(true);
                } else if (eventType == 0) {
                    ResetWorldAction.this.setEnabled(true);
                } else if (eventType == 3) {
                    ResetWorldAction.this.setEnabled(false);
                }
            }
        });
    }
}

