/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.collision.CollisionChecker;
import greenfoot.collision.ibsp.IBSPColChecker;
import java.awt.Graphics;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ColManager
implements CollisionChecker {
    private Map<Class<? extends Actor>, LinkedList<Actor>> freeObjects = new HashMap<Class<? extends Actor>, LinkedList<Actor>>();
    private Set<Class<? extends Actor>> collisionClasses = new HashSet<Class<? extends Actor>>();
    private CollisionChecker collisionChecker = new IBSPColChecker();

    private void makeCollisionObjects(Class<? extends Actor> cls, boolean includeSubclasses) {
        List classSet;
        Set<Map.Entry<Class<? extends Actor>, LinkedList<Actor>>> entries;
        if (cls == null) {
            entries = this.freeObjects.entrySet();
            for (Map.Entry<Class<? extends Actor>, LinkedList<Actor>> entry : entries) {
                for (Actor actor : entry.getValue()) {
                    this.collisionChecker.addObject(actor);
                }
                this.collisionClasses.add(entry.getKey());
            }
            this.freeObjects.clear();
        } else if (!this.collisionClasses.contains(cls) && (classSet = (List)this.freeObjects.remove(cls)) != null) {
            this.collisionClasses.add(cls);
            for (Actor actor : classSet) {
                this.collisionChecker.addObject(actor);
            }
        }
        if (includeSubclasses) {
            entries = this.freeObjects.entrySet();
            entries = new HashSet<Map.Entry<Class<? extends Actor>, LinkedList<Actor>>>(entries);
            for (Map.Entry<Class<? extends Actor>, LinkedList<Actor>> entry : entries) {
                if (!cls.isAssignableFrom(entry.getKey())) continue;
                this.makeCollisionObjects(entry.getKey(), false);
            }
        }
    }

    private <T extends Actor> void prepareForCollision(Actor actor, Class<T> cls) {
        this.makeCollisionObjects(actor.getClass(), false);
        this.makeCollisionObjects(cls, true);
    }

    @Override
    public void addObject(Actor actor) {
        Class<?> cls = actor.getClass();
        if (this.collisionClasses.contains(cls)) {
            this.collisionChecker.addObject(actor);
        } else {
            LinkedList<Actor> classSet = this.freeObjects.get(cls);
            if (classSet == null) {
                classSet = new LinkedList();
                this.freeObjects.put(cls, classSet);
            }
            classSet.add(actor);
        }
    }

    @Override
    public <T extends Actor> List<T> getIntersectingObjects(Actor actor, Class<T> cls) {
        this.prepareForCollision(actor, cls);
        return this.collisionChecker.getIntersectingObjects(actor, cls);
    }

    @Override
    public <T extends Actor> List<T> getNeighbours(Actor actor, int distance, boolean diag, Class<T> cls) {
        this.prepareForCollision(actor, cls);
        return this.collisionChecker.getNeighbours(actor, distance, diag, cls);
    }

    @Override
    public <T extends Actor> List<T> getObjects(Class<T> cls) {
        List<T> result = this.collisionChecker.getObjects(cls);
        Set<Map.Entry<Class<? extends Actor>, LinkedList<Actor>>> entries = this.freeObjects.entrySet();
        for (Map.Entry<Class<? extends Actor>, LinkedList<Actor>> entry : entries) {
            if (cls != null && !cls.isAssignableFrom(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    @Override
    public <T extends Actor> List<T> getObjectsAt(int x, int y, Class<T> cls) {
        this.makeCollisionObjects(cls, true);
        return this.collisionChecker.getObjectsAt(x, y, cls);
    }

    @Override
    public <T extends Actor> List<T> getObjectsInDirection(int x, int y, int angle, int length, Class<T> cls) {
        this.makeCollisionObjects(cls, true);
        return this.collisionChecker.getObjectsInDirection(x, y, angle, length, cls);
    }

    @Override
    public <T extends Actor> List<T> getObjectsInRange(int x, int y, int r, Class<T> cls) {
        this.makeCollisionObjects(cls, true);
        return this.collisionChecker.getObjectsInRange(x, y, r, cls);
    }

    @Override
    public List<Actor> getObjectsList() {
        return this.getObjects(null);
    }

    @Override
    public <T extends Actor> T getOneIntersectingObject(Actor object, Class<T> cls) {
        this.prepareForCollision(object, cls);
        return this.collisionChecker.getOneIntersectingObject(object, cls);
    }

    @Override
    public <T extends Actor> T getOneObjectAt(Actor object, int dx, int dy, Class<T> cls) {
        this.prepareForCollision(object, cls);
        return this.collisionChecker.getOneObjectAt(object, dx, dy, cls);
    }

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.collisionChecker.initialize(width, height, cellSize, wrap);
    }

    @Override
    public void paintDebug(Graphics g) {
        this.collisionChecker.paintDebug(g);
    }

    @Override
    public void removeObject(Actor object) {
        LinkedList<Actor> classSet = this.freeObjects.get(object.getClass());
        if (classSet != null) {
            classSet.remove(object);
        } else {
            this.collisionChecker.removeObject(object);
        }
    }

    @Override
    public void startSequence() {
        this.collisionChecker.startSequence();
    }

    @Override
    public void updateObjectLocation(Actor object, int oldX, int oldY) {
        if (!this.freeObjects.containsKey(object.getClass())) {
            this.collisionChecker.updateObjectLocation(object, oldX, oldY);
        }
    }

    @Override
    public void updateObjectSize(Actor object) {
        if (!this.freeObjects.containsKey(object.getClass())) {
            this.collisionChecker.updateObjectSize(object);
        }
    }
}

