/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import greenfoot.core.WorldHandler;
import greenfoot.gui.WorldCanvas;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;

public class LocationTracker {
    private static LocationTracker instance;
    private MouseEvent mouseButtonEvent;
    private Component sourceComponent;
    private MouseEvent mouseMovedEvent;

    public static void initialize() {
        MouseMotionAdapter mma = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                LocationTracker.instance().move(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LocationTracker.instance().click(e);
            }
        };
        WorldCanvas canvas = WorldHandler.getInstance().getWorldCanvas();
        canvas.addMouseListener(ma);
        canvas.addMouseMotionListener(mma);
    }

    private LocationTracker() {
        try {
            AWTEventListener listener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    MouseEvent me = (MouseEvent)event;
                    if (((long)event.getID() & 0x20L) != 0L) {
                        LocationTracker.instance().move(me);
                    }
                    if (((long)event.getID() & 0x10L) != 0L) {
                        LocationTracker.instance().click(me);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(listener, 48L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static synchronized LocationTracker instance() {
        if (instance == null) {
            instance = new LocationTracker();
        }
        return instance;
    }

    public MouseEvent getMouseButtonEvent() {
        return this.mouseButtonEvent;
    }

    public MouseEvent getMouseMotionEvent() {
        return this.mouseMovedEvent;
    }

    private void move(MouseEvent e) {
        this.mouseMovedEvent = this.translateEvent(e);
    }

    private void click(MouseEvent e) {
        this.mouseButtonEvent = this.translateEvent(e);
    }

    private MouseEvent translateEvent(MouseEvent e) {
        Component source = e.getComponent();
        if (source != this.sourceComponent) {
            e = SwingUtilities.convertMouseEvent(source, e, this.sourceComponent);
        }
        return e;
    }

    public void setSourceComponent(Component source) {
        this.sourceComponent = source;
    }

    static {
        LocationTracker.instance();
    }
}

