/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.utility.Debug;
import greenfoot.sound.AudioLine;
import greenfoot.sound.GreenfootAudioInputStream;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundPlaybackListener;
import greenfoot.sound.SoundUtils;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundStream
implements Sound,
Runnable {
    private static final int CLOSE_TIMEOUT = 1000;
    private boolean loop = false;
    private boolean stop = true;
    private boolean pause = false;
    private boolean restart = false;
    private boolean stopped = true;
    private final GreenfootAudioInputStream inputStream;
    private final SoundPlaybackListener playbackListener;
    private volatile AudioLine line;
    private AudioFormat format;
    private DataLine.Info info;
    private Thread playThread;

    private static void printDebug(String s) {
    }

    public SoundStream(GreenfootAudioInputStream inputStream, SoundPlaybackListener playbackListener) {
        this.playbackListener = playbackListener;
        this.inputStream = inputStream;
        try {
            this.format = inputStream.getFormat();
            this.info = new DataLine.Info(SourceDataLine.class, this.format);
            this.line = this.initialiseLine(this.info, this.format);
        }
        catch (IllegalArgumentException e) {
            SoundExceptionHandler.handleIllegalArgumentException(e, inputStream.getSource());
        }
        catch (LineUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
        }
    }

    @Override
    public synchronized void play() {
        if (this.isPlaying()) {
            this.loop = false;
        } else {
            this.startPlayback();
        }
    }

    @Override
    public synchronized void loop() {
        this.loop = true;
        if (!this.isPlaying()) {
            this.startPlayback();
        }
    }

    private void startPlayback() {
        if (!this.pause) {
            this.restart = true;
            if (this.playThread == null) {
                SoundStream.printDebug("Starting new playthread");
                this.playThread = new Thread((Runnable)this, "SoundStream:" + this.inputStream.getSource());
                this.playThread.start();
            }
            if (this.line != null) {
                this.line.reset();
            }
        }
        this.stopped = false;
        this.pause = false;
        this.stop = false;
        if (this.line != null) {
            this.line.start();
        }
        this.notifyAll();
        this.playbackListener.playbackStarted(this);
    }

    @Override
    public synchronized void close() {
        if (this.line != null) {
            this.reset();
            this.line.close();
            this.notifyAll();
            this.playbackListener.playbackStopped(this);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.stop) {
            this.stop = true;
            this.stopped = true;
            this.pause = false;
            this.line.reset();
            this.notifyAll();
            this.playbackListener.playbackStopped(this);
        }
    }

    @Override
    public synchronized void pause() {
        if (!this.stopped && !this.pause) {
            this.line.stop();
            this.pause = true;
            this.notifyAll();
            this.playbackListener.playbackPaused(this);
        }
    }

    @Override
    public synchronized boolean isPlaying() {
        return !this.stopped && !this.pause;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.stopped && !this.pause;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.pause;
    }

    public String toString() {
        return this.inputStream.getSource() + " " + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean stayAlive = true;
        try {
            while (stayAlive) {
                int bytesRead;
                this.inputStream.restart();
                SoundStream soundStream = this;
                synchronized (soundStream) {
                    if (this.line == null || !this.format.matches(this.inputStream.getFormat())) {
                        this.format = this.inputStream.getFormat();
                        this.info = new DataLine.Info(SourceDataLine.class, this.format);
                        this.line = this.initialiseLine(this.info, this.format);
                    }
                    this.line.open();
                    this.restart = false;
                }
                int frameSize = this.format.getFrameSize();
                int bufferSize = SoundUtils.getBufferSizeToHold(this.format, 0.5);
                if (bufferSize == -1) {
                    bufferSize = 65536;
                }
                byte[] buffer = new byte[bufferSize];
                SoundStream.printDebug("Stream available (in bytes): " + this.inputStream.available() + " in frames: " + this.inputStream.available() / frameSize);
                int bytesInBuffer = bytesRead = this.inputStream.read(buffer, 0, bufferSize);
                SoundStream.printDebug(" read: " + bytesRead);
                while (bytesInBuffer > 0) {
                    int bytesToWrite = bytesInBuffer / frameSize * frameSize;
                    SoundStream soundStream2 = this;
                    synchronized (soundStream2) {
                        if (this.stop) {
                            break;
                        }
                        if (this.pause) {
                            this.doPause();
                        }
                        if (this.restart) {
                            SoundStream.printDebug("restart in thread");
                            this.line.reset();
                            this.inputStream.restart();
                            this.restart = false;
                            bytesInBuffer = 0;
                            bytesRead = 0;
                            bytesToWrite = 0;
                            SoundStream.printDebug("inputStream available after restart in thread: " + this.inputStream.available());
                        }
                    }
                    int written = this.line.write(buffer, 0, bytesToWrite);
                    SoundStream.printDebug(" wrote: " + written);
                    int remaining = bytesInBuffer - written;
                    if (remaining > 0) {
                        SoundStream.printDebug("remaining: " + remaining + "  written: " + written + "   bytesInBuffer: " + bytesInBuffer + "   bytesToWrite: " + bytesToWrite);
                        System.arraycopy(buffer, written, buffer, 0, remaining);
                    }
                    bytesInBuffer = remaining;
                    SoundStream.printDebug("remaining: " + remaining + "  written: " + written + "   bytesInBuffer: " + bytesInBuffer + "   bytesToWrite: " + bytesToWrite);
                    bytesRead = this.inputStream.read(buffer, bytesInBuffer, buffer.length - bytesInBuffer);
                    if (bytesRead != -1) {
                        bytesInBuffer += bytesRead;
                    }
                    SoundStream.printDebug(" read: " + bytesRead);
                }
                this.line.drain();
                SoundStream soundStream3 = this;
                synchronized (soundStream3) {
                    if (!this.loop || this.stop) {
                        this.line.reset();
                    }
                    if (!this.restart && !this.loop || this.stop) {
                        this.stopped = true;
                        this.playbackListener.playbackStopped(this);
                        try {
                            if (this.line.isOpen()) {
                                SoundStream.printDebug("WAIT");
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!this.restart && !this.loop || this.stop) {
                            this.line.close();
                            stayAlive = false;
                            this.reset();
                            SoundStream.printDebug("KILL THREAD");
                        }
                    }
                    SoundStream.printDebug(" 2 restart =  " + this.restart + "  stop = " + this.stop);
                    if (this.restart) {
                        this.restart = false;
                    }
                }
            }
            return;
        }
        catch (IllegalArgumentException e) {
            SoundExceptionHandler.handleIllegalArgumentException(e, this.inputStream.getSource());
            return;
        }
        catch (UnsupportedAudioFileException e) {
            SoundExceptionHandler.handleUnsupportedAudioFileException(e, this.inputStream.getSource());
            return;
        }
        catch (LineUnavailableException e) {
            SoundExceptionHandler.handleLineUnavailableException(e);
            return;
        }
        catch (IOException e) {
            SoundExceptionHandler.handleIOException(e, this.inputStream.getSource());
            return;
        }
        finally {
            if (stayAlive) {
                this.reset();
            }
            if (this.line != null) {
                this.line.close();
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.playbackListener.soundClosed(this);
        }
    }

    private synchronized void doPause() {
        if (this.pause) {
            while (this.pause) {
                try {
                    SoundStream.printDebug("In pause loop");
                    this.line.stop();
                    SoundStream.printDebug("In pause loop 2");
                    this.wait();
                }
                catch (InterruptedException e) {
                    Debug.reportError((String)("Interrupted while pausing sound: " + this.inputStream.getSource()), (Throwable)e);
                }
            }
            this.line.start();
        }
    }

    private AudioLine initialiseLine(DataLine.Info info, AudioFormat format) throws LineUnavailableException, IllegalArgumentException {
        SourceDataLine l = (SourceDataLine)AudioSystem.getLine(info);
        SoundStream.printDebug("buffer size: " + l.getBufferSize());
        return new AudioLine(l, format);
    }

    private synchronized void reset() {
        this.stopped = true;
        this.pause = false;
        this.loop = false;
        this.stop = true;
        this.playThread = null;
    }

    public long getLongFramePosition() {
        return this.line.getLongFramePosition();
    }

    @Override
    public void setVolume(int level) {
        this.line.setVolume(SoundUtils.logToLin(level));
    }

    @Override
    public int getVolume() {
        return this.line.getVolume();
    }
}

