#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from register import Register as Reg

class Akku(Reg):
    def __init__(self,name,bus,cb_Load=None,cb_Enable=None,cb_Value=None,cb_up=None,cb_down=None,cb_clr=None):
        """Construcs a Register with additional functions (up,down,clr,setHand).
name is a string that will be given back by the callbacks
bus is the bus from which the register can read and on which it can \'write\'
cb_Load is the function that shall be called when the register starts or stops reading from the bus
cb_Enable is the function that shall be called when the register starts or stops \'writing\' on the bus
cb_Value is the function that shall be called when the register changes it's value
All callback-parameters may be None if you don't want any functions to be called."""
        Reg.__init__(self,name,bus,cb_Load,cb_Enable,self._cb_Value)
        self.cb_Value = cb_Value
        self.cbU = cb_up
        self.cbD = cb_down
        self.cbC = cb_clr
        self.__zclr = 0
        self.__down = 0
        self.__up = 0
        
    def _cb_Value(self,name,value):
        if self.__zclr and value != 0: Reg.setValue(self,0)
        else: self.cb_Value(name,value)

    def up(self,level,maximum=255):
        "Increase the value (count one up)"
        if level != self.__up:
            if not level and not self.__zclr and not self._Register__load:
                Reg.setValue(self,(Reg.getValue(self)+1)%(maximum+1))
            self.__up = level
            if self.cbU != None: self.cbU(self.name,level)
    def down(self,level,maximum=255):
        "Decrease the value (count one down)"
        if level != self.__down:
            if not level:
                Reg.setValue(self,(Reg.getValue(self)-1)%(maximum+1))
            self.__down = level
            if self.cbD != None: self.cbD(self.name,level)
    def clr(self,level):
        "Reset the value (set the value to zero)"
        if level != self.__zclr:
            self.__zclr = level
            if level: Reg.setValue(self,0)
            if self.cbC != None: self.cbC(self.name,level)

    def setLoad(self,level):
        "If level = True the register will load the value of the bus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self._Register__load != level:
            self._Register__load = level
            if self._Register__bus != None:
                if level and not self.__zclr:
                    self._Register__bus.loginR(self)
                else:
                    try: self._Register__bus.logoutR(self)
                    except: pass
            if self.cb_l != None: self.cb_l(self.name,level)
