#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

import sys

class BusException(BaseException):
	pass
    
class Bus:
    def __init__(self,name,cb_Value=None,cb_Error=None):
        """Creates a bus with
name is a string that will be given back by callbacks
cb_Value is the function that shall be called when the value of the bus changes
cb_Error is the function that shall be called when more than one register is writing on the bus
Both callback-parameters may be None if you don't want any functions to be called."""
        self.name = name
        self.cb_v = cb_Value
        self.cb_e = cb_Error
        self.__writer = []
        self.__reader = []
        self.__value = None

    def setValue(self,value):
        "Sets the value of the bus.\nMust be integer between 0 and 255 or None for high-impedance"
        assert type(value) == int and 0 <= value <= 255 or value == None
        if self.__value != value:
            self.__value = value
            if self.cb_v != None:
                self.cb_v(value)

    def update(self):
        "Shall be called when the bus has to update it's value and/or the registers values"
        if self.__writer != []:
            self.setValue(self.__writer[0].getValue())
        for reader in self.__reader:
            reader.setValue(self.__value)

    def loginR(self,reg):
        "Login the register (reg) as reader"
        self.__reader += [reg]
        reg.setValue(self.__value)

    def logoutR(self,reg):
        "Logout the register (reg) as reader"
        try: self.__reader.remove(reg)
        except:
            raise BusException(self.name+' Can\'t remove Register "'+reg.name+'"\nIt never was loged in as Reader!')

    def loginW(self,reg):
        "Login the register (reg) as writer"
        if self.__writer != []:
            if self.cb_e != None: self.cb_e(name,writer+[reg])
            else:
                raise BusException(self.__writer[0].name+' and '+reg.name+' are both trying to write on '+self.name)
        else:
            self.setValue(reg.getValue())
            self.__writer += [reg]
            self.update()

    def logoutW(self,reg):
        "Logout the register (reg) as writer"
        try: self.__writer.remove(reg)
        except:
            raise BusException(self.name+' Can\'t remove Register "'+reg.name+'"\nIt never was loged in as Writer!')
        assert self.__writer == []
        self.setValue(None)
        self.update()
