#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from threading import Lock,current_thread
from speicher import Speicher
from akku import Akku
from br import BR
from hs import Handsteuerung as HS
from sw import SW
from bus import Bus

class Model:
    """Molde is a class to combine all parts of the bonsai-hardware and
can simulate a fully-working Bonsai-machine (without GUI)"""
    Bnr = ('Speicher','PC','BR','Akku','HS','SW')
    def __init__(self,cb_Byte1=None,cb_Byte2=None,cb_HalfByte=None,cb_MProw=None,
                 cb_ZeroChk=None,cb_Takt=None,cb_Load=None,cb_Enable=None,
                 cb_update=None,cb_up=None,cb_down=None,cb_speicher_state=None,cb_clr=None):
        "Creates a Model-Object to simulate a Bonsai-machine"
        self.cbB1  = cb_Byte1
        self.cbB2  = cb_Byte2
        self.cbHB  = cb_HalfByte
        self.cbMPR = cb_MProw
        self.cbZC  = cb_ZeroChk
        self.cbT   = cb_Takt
        self.cbL   = cb_Load
        self.cbE   = cb_Enable
        self.cbU   = cb_update
        self.cbUp  = cb_up
        self.cbDo  = cb_down
        self.cbSS  = cb_speicher_state
        self.cbClr = cb_clr

        self.__totakt = []
        self.taktL = Lock()
        self.taktL.acquire()
        
        self.databus = Bus('Databus')
        self.addrbus = Bus('Addrbus')
        self.MPCbus = Bus('MPCbus')
        
        self.s  = Speicher('Speicher',self.addrbus,self.databus,self._load,self._enable,self._B1,self._B2)
        self.setSpeicher = self.s.set
        self.pc = Akku('PC',self.addrbus,self._load,self._enable,self._B1,self._up,self._down,self._clr)
        self.br = BR('BR',self.databus,self.addrbus,self.MPCbus,
                     self._ZC,self._HB,self._enable,self._load,self._B1)
        self.a  = Akku('Akku',self.databus,self._load,self._enable,self._B1,self._up,self._down,self._clr)
        self.hs = HS('HS',self.databus,self.taktL,self._takt,self._enable,self._hand,self._reset)
        self.sw = SW('SW',self.MPCbus,self._load,self._HB,self._MPCr,self._enable,self._CS)

        self.CMDs = (None,None,lambda l:self.s.setEnable(l,0),lambda l:self.s.setLoad(l,0),
                     lambda l:self.a.up(l),lambda l:self.a.down(l),
                     self.a.setLoad,self.a.setEnable,
                     self.pc.setLoad,self.pc.setEnable,
                     self.br.setLoad,self.br.setEnable,
                     lambda l:self.pc.up(l),lambda l:self._pczUp(l),
                     None,None)
        #ROW als Tuple aus (nr,flag)-Tupeln
        self.ROW = ((3,0),(6,0), (8,0),(10,0),       #Alle Leser ausschalten
                    (2,0),(7,0), (9,0),(11,0),       #Alle Schreiber ausschalten
                    (4,0),(5,0),(12,0),(13,0),       #\Alle Up/Down-CMDs ausschalten
                    (4,1),(5,1),(12,1),(13,1),       #/Alle Up/Down-CMDs einschalten
                    (2,1),(7,1), (9,1),(11,1),       #Alle Schreiber einschalten
                    (3,1),(6,1), (8,1),(10,1))       #Alle Leser einschalten
        self.iD = {(0, 0):lambda:self.s.setPin(0),
                   (0, 1):lambda:self.s.setPin(1),
                   (0, 2):lambda:self.s.setPin(2),
                   (0, 3):lambda:self.s.setEnable(1),
                   (0, 4):lambda:self.s.setEnable(0),
                   (0, 5):lambda:self.s.setLoad(1),
                   (0, 6):lambda:self.s.setLoad(0),
                   (1, 0):lambda:self.pc.up(1),
                   (1, 1):lambda:self.pc.up(0),
                   (1, 2):lambda:self.pc.down(1),
                   (1, 3):lambda:self.pc.down(0),
                   (1, 4):lambda:self.pc.clr(1),
                   (1, 5):lambda:self.pc.clr(0),
                   (3, 0):lambda:self.a.up(1),
                   (3, 1):lambda:self.a.up(0),
                   (3, 2):lambda:self.a.down(1),
                   (3, 3):lambda:self.a.down(0),
                   (3, 4):lambda:self.a.clr(1),
                   (3, 5):lambda:self.a.clr(0),
                   (4, 0):lambda:self.hs.setInput(7,0),
                   (4, 1):lambda:self.hs.setInput(7,1),
                   (4, 2):lambda:self.hs.setInput(6,0),
                   (4, 3):lambda:self.hs.setInput(6,1),
                   (4, 4):lambda:self.hs.setInput(5,0),
                   (4, 5):lambda:self.hs.setInput(5,1),
                   (4, 6):lambda:self.hs.setInput(4,0),
                   (4, 7):lambda:self.hs.setInput(4,1),
                   (4, 8):lambda:self.hs.setInput(3,0),
                   (4, 9):lambda:self.hs.setInput(3,1),
                   (4,10):lambda:self.hs.setInput(2,0),
                   (4,11):lambda:self.hs.setInput(2,1),
                   (4,12):lambda:self.hs.setInput(1,0),
                   (4,13):lambda:self.hs.setInput(1,1),
                   (4,14):lambda:self.hs.setInput(0,0),
                   (4,15):lambda:self.hs.setInput(0,1),
                   (4,16):lambda:self.hs.setSchnell(1),
                   (4,17):lambda:self.hs.setSchnell(0),
                   (4,18):lambda:self.hs.setDauer(1),
                   (4,19):lambda:self.hs.setDauer(0),
                   (4,20):lambda:self.hs.taktflanke(1),
                   (4,21):lambda:self.hs.taktflanke(0),
                   (4,22):lambda:self.hs.setHand(1),
                   (4,23):lambda:self.hs.setHand(0),
                   (4,24):lambda:self.hs.reset(1),
                   (4,25):lambda:self.hs.reset(0)}
            
        #Inititalisierung
        self.hs.setSchnell(0)
        self.hs.setDauer(0)
        self.hs.setHand(0)
        if self.cbMPR != None:
            self.cbMPR(0)
        if self.cbE != None: self.cbE(5,1)
        if self.cbSS != None: self.cbSS(0)
        self.hs.mainloop()

    def getSpeicher(self):
        """Returns the data content of the momory.
It'll return a list of integers with the length of 256."""
        inhalt = self.s.get()
        for i in range(len(inhalt)):
            inhalt[i] = bin(inhalt[i])[2:]
        return inhalt
            
    def input(self,board,button):
        """Pass a input to the Bonsai.
'board' may be an integer between 0 and 5.
'board' stands for one of the six boards of a Bonsai-machine. Count from the upper-left board to the lower-right one.
'button' is the used Button/Switch. It's counted like 'board'."""
        self.iD[(board,button)]()
        self.cbU
    def _clr(self,name,level):
        """Intern use only.
Handles clr-callbacks from PC and Akku."""
        assert self.Bnr.index(name) in (1,3)
        if self.cbClr != None:
            self.cbClr(self.Bnr.index(name),level)        
    def _up(self,name,level):
        """Intern use only.
Handles up-callbacks from PC and Akku."""
        assert self.Bnr.index(name) in (1,3)
        if self.cbUp != None:
            self.cbUp(self.Bnr.index(name),level)
    def _down(self,name,level):
        """Intern use only.
Handles down-callbacks from PC and Akku."""
        assert self.Bnr.index(name) in (1,3)
        if self.cbDo != None:
            self.cbDo(self.Bnr.index(name),level)
    def _B1(self,name,value):
        """Intern use only.
Handles Byte1-callbacks from boards 0,1,2 and 3.
Passes the Callback to self.cbB1 to set the new value of that LED-row."""
        assert self.Bnr.index(name) in (0,1,2,3)
        if self.cbB1 != None:
            self.cbB1(self.Bnr.index(name),value)
    def _B2(self,name,value):
        """Intern use only.
Handles Byte2-callbacks from boards 0 and 5.
Passes the Callback to self.cbB2 to set the new value of that LED-row."""
        assert self.Bnr.index(name) in (0,5)
        if self.cbB2 != None:
            self.cbB2(self.Bnr.index(name),value)
    def _load(self,name,level):
        """Intern use only.
Handles Load-callbacks from all boards but SW."""
        assert self.Bnr.index(name) in (0,1,2,3,5)
        if name == 'Speicher':
            self.hs.setEnable(level)
        if self.cbL != None:
            self.cbL(self.Bnr.index(name),level)
    def _enable(self,name,level):
        """Intern use only.
Handles Enable-callbacks from all boards."""
        assert self.Bnr.index(name) in range(6)
        if self.cbE != None:
            self.cbE(self.Bnr.index(name),level)
    def _ZC(self,name,level):
        """Intern use only.
Passes the ZeroCheck-Callback to self.cbZC to set the ZC-LED to the current level."""
        assert name == 'BR'
        if self.cbZC != None:
            self.cbZC(level)
    def _HB(self,name,value):
        """Intern use only.
Handles HalfByte-callbacks from boards 2 and 5.
Passes the Callback to self.cbHB to set the new value of that LED-row."""
        assert self.Bnr.index(name) in (2,5)
        if self.cbHB != None:
            self.cbHB(self.Bnr.index(name),value)
    def _MPCr(self,name,value):
        """Intern use only.
Handles MicroProgrammRow-callbacks from SW.
Passes the Callback to self.cbMPR to set the new row of the MicroProgramm"""
        assert name == 'SW'
        if self.cbMPR != None:
            self.cbMPR(value)
    def _takt(self,name,level):
        """Intern use only.
Handles Clock-callbacks from HS."""
        assert name == 'HS'
        if current_thread().getName() != 'MainThread':  #Thread-Sicherung
            self.__totakt += [(level)]
        else:
            if level: self.sw.takt()
            if self.cbT != None:
                self.cbT(level)
    def _hand(self,name,level):
        """Intern use only.
Handles Hand-callbacks from HS."""
        assert name in ('HS','model')
        if level: self.sw.setEnable(0)
        self.pc.setEnable(level)
        if not level: self.sw.setEnable(1)
        if self.cbSS != None: self.cbSS(level)
    def _reset(self,name,level):
        """Intern use only.
Handles Reset-callbacks from HS."""
        assert name == 'HS'
        if level:
            self.sw.setEnable(0)
            self.sw.reset(1)
            self.pc.clr(1)
            self.pc.clr(0)
            self.a.clr(1)
            self.a.clr(0)
            self.pc.setEnable(1)
            self.a.setEnable(1)
            self.br.setLoad(1)
        else:
            self.pc.setEnable(0)
            self.br.setLoad(0)
            self.a.setEnable(0)
            self.sw.reset(0)
            self._hand('model',self.hs.getHand())
        
    def _pczUp(self,level):
        """Intern use only.
Increases the PC if Data on Data-bus is zero.
This condition is checkt with the ZeroCheck on BR."""
        if self.br.ZC.isZero:
            self.pc.up(level)

    def _CS(self,name,cmd):
        """Intern use only.
Handles the ControllSignal-Callback from SW."""
        assert name == 'SW'
        for nr,flag in self.ROW:
            if cmd[nr] == flag:
                self.CMDs[nr](flag)
        value1 = ''
        for i in range(8):
            value1 += str(cmd[i])
        value1 = int(value1,2)
        value2 = ''
        for i in range(8,16):
            value2 += str(cmd[i])
        value2 = int(value2,2)
        if self.cbB1 != None:
            self.cbB1(5,value1)
        if self.cbB2 != None:
            self.cbB2(5,value2)

    def update(self):
        """Updates the Model.
This function musst be called freqently.
It gives HS the chace to send clock pulses if turned on auto ('dauer')."""
        self.taktL.release()
        self.taktL.acquire()
        for level in self.__totakt:
            if level: self.sw.takt()
            if self.cbT != None:
                self.cbT(level)
        self.__totakt = []

    def quit(self):
        """Please call this function for clean determining."""
        self.hs.quit()

    def __del__(self):
        self.quit()
        

if __name__ == '__main__':
    m = Model(cb_Byte1=lambda *args:print('B1',*args),cb_Byte2=lambda *args:print('B2',*args),
              cb_HalfByte=lambda *args:print('HB',*args),cb_MProw=lambda *args:print('MPRow',*args),
              cb_ZeroChk=lambda *args:print('ZC',*args),cb_Takt=lambda *args:print('t',*args),
              cb_Load=lambda *args:print('Load',*args),cb_Enable=lambda *args:print('Enable',*args))
    
