#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

class Register:
    def __init__(self,name,bus,cb_Load=None,cb_Enable=None,cb_Value=None):
        """Construcs a Register with
name is a string that will be given back by the callbacks
bus is the bus from which the register can read and on whicht it can \'write\'
cb_Load is the function that shall be called when the register starts or stops reading from the bus
cb_Enable is the function that shall be called when the register starts or stops \'writing\' on the bus
cb_Value is the function that shall be called when the register changes it's value
All callback-parameters may be None if you don't want any functions to be called."""
        self.name = name
        self.__bus = bus
        self.cb_l = cb_Load
        self.cb_e = cb_Enable
        self.cb_v = cb_Value
        self.__value = 0            #PowerOn-Reset: value  := 0
        self.__load = False         #PowerOn-Reset: load   := False
        self.__enable = False       #PowerOn-Reset: enable := False

    def setBus(self,bus):
        "Sets a bus from which the register can read and on whicht it can \'write\'"
        self.__bus = bus 
        if self.__load: self.__bus.loginR(self)
        if self.__enable: self.__bus.loginW(self)

    def setValue(self,value):
        "Sets the value of the register to \'value\'"
        assert type(value)==int and 0<=value<=255 or value == None
        if self.__value != value:
            if value == None: self.__value = 255
            else: self.__value = value
            if self.__bus != None and self.__enable:
                self.__bus.update()
            if self.cb_v != None: self.cb_v(self.name,self.__value)

    def getValue(self):
        "returns the value of the register"
        return self.__value

    def setLoad(self,level):
        "If level = True the register will load the value of the bus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self.__load != level:
            self.__load = level
            if self.__bus != None:
                if level: self.__bus.loginR(self)
                else: self.__bus.logoutR(self)
            if self.cb_l != None: self.cb_l(self.name,level)

    def setEnable(self,level):
        "If level = True the register will write it's value on the bus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self.__enable != level:
            self.__enable = level
            if self.__bus != None:
                if level:
                    self.__bus.loginW(self)
                else:
                    self.__bus.logoutW(self)
            if self.cb_e != None: self.cb_e(self.name,level)

class TwoBusRegister(Register):
    def __init__(self,name,rbus,wbus,cb_Load=None,cb_Enable=None,cb_Value=None):
        """Construcs a Register with
name is a string that will be given back by the callbacks
rbus is the bus from which the register can read from
wbus is the bus which the register can \'write\' on
cb_Load is the function that shall be called when the register starts or stops reading from the bus
cb_Enable is the function that shall be called when the register starts or stops \'writing\' on the bus
cb_Value is the function that shall be called when the register changes it's value
All callback-parameters may be None if you don't want any functions to be called."""
        Register.__init__(self,name,'FakeBus',cb_Load,cb_Enable,cb_Value)
        self.__rbus = rbus
        self.__wbus = wbus
        del self._Register__bus

    def setRBus(self,rbus):
        "Sets a bus from which the register can read"
        self.__rbus = rbus
        if self._Register__load: self.__rbus.loginR(self)
    def setWBus(self,wbus):
        "Sets a bus which the register can \'write\' on"
        self.__wbus = wbus
        if self._Register__enable: self.__wbus.loginW(self) 

    def setValue(self,value):
        "Sets the value of the register to \'value\'"
        assert type(value)==int and 0<=value<=255 or value == None
        if self._Register__value != value:
            if value == None: self._Register__value = 255
            else: self._Register__value = value
            if self.__wbus != None and self._Register__enable:
                self.__wbus.update()
            if self.cb_v != None: self.cb_v(self.name,self._Register__value)            

    def setLoad(self,level):
        "If level = True the register will load the value of the RBus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self._Register__load != level:
            self._Register__load = level
            if self.__rbus != None:
                if level: self.__rbus.loginR(self)
                else: self.__rbus.logoutR(self)
            if self.cb_l != None: self.cb_l(self.name,level)
    def setEnable(self,level):
        "If level = True the register will write it's value on the WBus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self._Register__enable != level:
            self._Register__enable = level
            if self.__wbus != None:
                if level: self.__wbus.loginW(self)
                else: self.__wbus.logoutW(self)
            if self.cb_e != None: self.cb_e(self.name,level)
            
if __name__ == '__main__':
    r1 = Register('Dummy-Reg1s',None,*3*(print,))
    r2 = TwoBusRegister('Dummy-Reg2',None,None,*3*(print,))
