#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from akku import Akku
from register import Register

class MPC(Akku):
    def __init__(self,name,MPCBus,cb_Load=None,cb_Value=None):
        "Creates a Akku but with special clear behavior."
        Akku.__init__(self,name,MPCBus,cb_Load,None,cb_Value)

    def up(self):
        Akku.up(self,1)
        Akku.up(self,0,15)

#-------------MikroProgramm-------------
MP = ((0,0,0,0,0,0,0,0, 0,1,0,0,0,0,0,0),
      (0,0,1,0,0,0,0,0, 0,1,1,0,0,0,0,0),
      (0,1,1,0,0,0,0,0, 0,1,0,0,0,0,0,0),
      (0,0,0,0,0,0,0,0, 0,0,0,1,0,0,0,0),
      (0,0,1,0,0,0,1,0, 0,0,0,1,0,0,0,0),
      (0,0,0,0,1,0,0,0, 0,0,0,1,1,0,0,0),
      (1,0,0,1,0,0,0,1, 0,0,0,1,0,0,0,0),
      (0,0,0,0,0,0,0,0, 0,0,0,1,0,0,0,0),
      
      (0,0,1,0,0,0,1,0, 0,0,0,1,0,0,0,0),
      (0,0,0,0,0,1,0,0, 0,0,0,1,1,0,0,0),
      (1,0,0,1,0,0,0,1, 0,0,0,1,0,0,0,0),
      (1,0,0,0,0,0,0,0, 1,0,0,1,0,0,0,0),
      (0,0,0,0,0,0,0,0, 0,0,0,1,0,0,0,0),
      (0,0,1,0,0,0,0,0, 0,0,0,1,1,0,0,0),
      (1,0,1,0,0,0,0,0, 0,0,0,1,0,1,0,0),
      (0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0))
#      0 1 2 3 4 5 6 7  8 9 1 1 1 1 1 1
#                           0 1 2 3 4 5
#     |M|M|S|S|A|A|A|A||P|P|B|B|P|P|-|-|
#     |P|P|p|p|k|k|k|k||C|C|R|R|C|C|-|-|
#     |C|C|e|e|k|k|k|k|| | | | | | |-|-|
#     | | |i|i|u|u|u|u||l|e|l|e|u|z|-|-|
#     |c|l|c|c| | | | ||o|n|o|n|p|e|-|-|
#     |l|o|e|e|u|d|l|e||a|a|a|a| |r|-|-|
#     |r|a|r|r|p|o|o|n||d|b|d|b| |o|-|-|
#     | |d| | | |w|a|a|| |l| |l| |-|-|-|
#     | | |e|l| |n|d|b|| |e| |e| |u|-|-|
#     | | |n|o| | | |l|| | | | | |p|-|-|
#     | | |a|a| | | |e|| | | | | | |-|-|
#     | | |b|d| | | | || | | | | | |-|-|
#     | | |l| | | | | || | | | | | |-|-|
#     | | |e| | | | | || | | | | | |-|-|

class SW:
    def __init__(self,name,MPCBus,cb_Load=None,cb_MPC=None,cb_MPCRow=None,cb_Enable=None,cb_CS=None):
        """Creates a board, that executes the MicroProgramm(=MP).
name is a string that will be given back by the callbacks.
MPCBus is the bus SW can read the next line to jump to in the MP.
This line depends on the Tasks the SW shall execute. Therefor use:
line  3: INC
line  7: DEC
line 11: JMP
line 12: TST
cb_Load is the function that shall be called when SW starts or stops reading from the bus
cb_MPC is the function that shall be called when the MicroProgrammCounter (MPC) changes it's value
cb_MPCRow is the function that shall be called when an other line in the MP is active.
cb_Enable is the function that shall be called when the register starts or stops \'writing\' on the bus
cb_CS is the function that shall be called when the CommandSignals (CS) change."""
        self.name = name
        self._enable = 1
        self.cb_Load = cb_Load
        self.cb_MPC = cb_MPC
        self.cb_MPCRow = cb_MPCRow
        self.cb_Enable = cb_Enable
        self.cb_CS = cb_CS
        self.MPC = MPC('SW_MPC',MPCBus,cb_Value=self._MPCValue)
        self.CMDs = (0,)*16

    def _MPCValue(self,name,value):
        """Intern use only.
Handles the cb_value of MPC."""
        assert name == 'SW_MPC'
        global MP
        if self.cb_Load != None: self.cb_Load(self.name,MP[value][1])
        if self.cb_MPC != None: self.cb_MPC(self.name,value)
        if self.cb_MPCRow != None: self.cb_MPCRow(self.name,value)

    def setEnable(self,level):
        """If level is True SW will send all CSs as defined in the MP.
If level is False SW will turn alls CSs to low level signals."""
        self._enable = level
        if self.cb_Enable != None: self.cb_Enable(self.name,level)
        if self.cb_CS != None:
            if level: self.cb_CS(self.name,self.CMDs)
            else:
                self.MPC.clr(0)
                self.MPC.setLoad(0)
                self.cb_CS(self.name,(0,)*16)

    def reset(self,level):
        """If level is True the SW starts a reset.
With level = False you stop the reset."""
        self.MPC.clr(level)
        if level:
            if self.cb_MPCRow != None: self.cb_MPCRow(self.name,None)
            if self.cb_CS != None and self._enable: self.cb_CS(self.name,(0,)*16)
        else:
            if self.cb_MPCRow != None: self.cb_MPCRow(self.name,self.MPC.getValue())

    def takt(self):
        """Call this function if the clock signal turns to True.
It will inc the MPC if necessary and will load the new CSs into the output register."""
        self._loadInCMDs()
        self.MPC.up()           #Wenn MPC-clr v MPC-load wird die Anfrage in MPC abgefangen

    def _loadInCMDs(self):
        """Intern use only.
Loads the CSs from the MPRow into the output register.
(Actually there are two output registers for all 16 CSs while only 14 are used
and only 12 of them are extern singals.)"""
        global MP
        self.CMDs = MP[self.MPC.getValue()]
        if self._enable:
            self.MPC.clr(self.CMDs[0])
            self.MPC.setLoad(self.CMDs[1])
            if self.cb_CS != None: self.cb_CS(self.name,self.CMDs)
