#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from tkinter import Canvas, PhotoImage

class SwitchCanvas(Canvas):
    def __init__(self, PictureOff, PictureOn, SwitchRecs, cbRecs = None, master=None, cnf={}, **kw):
        """Construct a canvas widget with the parent MASTER.              
Valid resource names: background, bd, bg, borderwidth, closeenough,
confine, cursor, height, highlightbackground, highlightcolor,
highlightthickness, insertbackground, insertborderwidth,
insertofftime, insertontime, insertwidth, offset, relief,
scrollregion, selectbackground, selectborderwidth, selectforeground,
state, takefocus, width, xscrollcommand, xscrollincrement,
yscrollcommand, yscrollincrement.
PictureOff shall be a string describing the path of the Picture in Off-Status
PictureOn shall be a string describing the path of the Picture in On-Status
SwitchRecs in from of [x11,y11,x12,y12, x21,y21,x22,y22, ...]
cbRecs as list of Callbacks"""
        self.poff = PhotoImage(file=PictureOff)
        self.pon  = PhotoImage(file=PictureOn)
        kw['width']  = self.poff.width()
        kw['height'] = self.poff.height()
        if not 'border' in kw.keys():
            kw['border'] = -2
        
        Canvas.__init__(self, master, cnf, **kw)
        assert len(SwitchRecs)%4 == 0
        if cbRecs == None:
            cbRecs = (len(SwitchRecs)//4)*[None]
        assert len(SwitchRecs)//4 == len(cbRecs)
        self.create_image(0,0,image=self.poff,anchor='nw')

        self.parts = []
        for i in range(len(SwitchRecs)//4):
            x1 = SwitchRecs[i*4]
            y1 = SwitchRecs[i*4+1]
            x2 = SwitchRecs[i*4+2]-1
            y2 = SwitchRecs[i*4+3]-1
            self.parts += [Canvas(master=self,width=x2-x1,height=y2-y1,border=-2,bg='pink')]
            self.parts[-1].create_image(-x1,-y1,image=self.poff,tags='bild',anchor='nw')
            self.parts[-1].place(x=x1,y=y1)
            self.parts[-1].zustand = 0
            self.parts[-1].id = i
            if cbRecs[i] != None:
                self.part_bind(i,'<Button-1>',cbRecs[i])


    def setOn(self,part):
        "Sets the part on.\n Part may be an int or \'all\' for all parts"
        if part == 'all':
            for p in self.parts:
                p.zustand = 1
                p.itemconfig('bild',image=self.pon)
        else:
            self.parts[part].zustand = 1
            self.parts[part].itemconfig('bild',image=self.pon)
    def setOff(self,part):
        "Sets the part off.\n Part may be an int or \'all\' for all parts."
        if part == 'all':
            for p in self.parts:
                p.zustand = 0
                p.itemconfig('bild',image=self.poff)
        else:
            self.parts[part].zustand = 0
            self.parts[part].itemconfig('bild',image=self.poff)
    def toggle(self,part):
        "Toggles the status of the part.\n Part may be an int or \'all\' for all parts."
        if part == 'all':
            for i in range(len(self.parts)):
                if self.parts[i].zustand: self.setOff(i)
                else: self.setOn(i)
        else:
            if self.parts[part].zustand: self.setOff(part)
            else: self.setOn(part)

    def setPOn(self,src):
        "Changes the picture in state \'on\'"
        self.pon.config(file=src)
    def setPOff(self,src):
        "Changes the picture in state \'off\'"
        self.poff.config(file=src)

    def part_bind(self,part,sequence,func):
        "Binds an event on part.\n Part may be an int or \'all\' for all parts.\nThis Callback doesn't have any parameters."
        if part == 'all':
            for i in range(len(func)):
                self.parts[i].bind(sequence,func[i])
                #self.parts[i].cb = func[i]
        else:
            self.parts[part].bind(sequence,func)
            #self.parts[part].cb = func

    def _cb(self,event):
        "Intern function."
        for func in event.widget.cb: func()
        

def a(event):
    global s
    s.setPOff('on.gif')
import tkinter as tk
if __name__ == '__main__':
    root = tk.Tk()
    root.geometry('50x50+50+50')
    root.bind('<Button-1>',a)
    s = SwitchCanvas('off.gif','on.gif',[1,1,2,2],master=root, bg='black')
    s.part_bind('all','<Button-1>',[lambda:print('cb!')])
    s.place(x=5,y=5)
    s.setOn(0)
    root.mainloop()
