#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from register import Register
from time import process_time,sleep
from threading import Thread

TAKT = 25  #Max-Leistung in Takten pro Sekunde
class Handsteuerung():
    def __init__(self,name,bus,tLock,cbTakt=None,cbEnable=None,cbHand=None,cbReset=None,cbDauer=None,cbSchnell=None):
        """Creates a board for manual maincontroll.
name is a string that will be given back by the callbacks
bus is the bus from which the register can read andwhich it can \'write\' on
tLock may be a threading.Lock or a threading.RLock that is acquired if the boards mainloop want to give a clock impulse
cbTakt is the function that shall be called when this board gives a clock impulse
cbEnable is the function that shall be called when this board starts or stops \'writing\' on the bus
cbHand is the function that shall be called when this board starts or stops the manual mode
cbReset is the function that shall be called when this board wants to send a reset impulse
cbDauer is the function that shall be called when this board starts or stops sending the clock impulses continuously
cbSchnell is the function that shall be called when this board changes the speed of the automatically sent clock impulses from fast to slow or the other way around."""
        self.name = name
        self.cb_e = cbEnable
        self.tL = tLock
        self.t = None
        self.__reg = Register('HS_Reg',bus)
        self.cb_h = cbHand
        self.cb_t = cbTakt
        self.cb_e = cbEnable
        self.cb_d = cbDauer
        self.cb_s = cbSchnell
        self.cb_r = cbReset
        self.__enable = 0
        self.__load = 0
        self.__hand = None      #\
        self.__dauer = None     # }Diese Werter müssen extern initialisiert werden,
        self.__schnell = None   #/  je nach dem, wie die Kippschaltern stehen.
        self.z_reset = False
        self.exit = 0
        
    def reset(self,level):
        """This function will do a reset.
A reset-signal must happen in to phases.
First a high-level signal and then a low-level signal."""
        if self.cb_r != None:
            self.cb_r(self.name,level)
        if level:
            self.z_reset = True
            if self.cb_t != None: self.cb_t(self.name,1)
        else:
            sleep(0.25)
            self.z_reset = False
            if self.cb_t != None: self.cb_t(self.name,0)
    def setEnable(self,level,fromUsr=True):
        "If level = True the this board will write it's value on the bus (only if it's in manual-mode"
        if self.__hand or not fromUsr:
            self.__enable = level
            self.__reg.setEnable(level)
            if self.cb_e != None: self.cb_e(self.name,level)
    def setLoad(self,level,fromUsr=True):
        "Actually this function doesn't make sense for this board though it's there for completeness.\n\
If level = True the this board will read the value from the bus (only if it's in manual mode)"
        if self.__hand or not fromUsr:
            self.__load = level
            self.__reg.setLoad(level)
    def setHand(self,level):
        "If level = True this board will be set into manual mode."
        assert type(level) == bool or type(level) == int and level in (0,1)
        self.__hand = level
        if self.cb_h != None: self.cb_h(self.name,level)
    def getHand(self):
        "Return the state of 'hand'."
        return self.__hand
    
    def setDauer(self,level):
        "If level = True the board will send it's clock impulses continuously."
        assert type(level) == bool or type(level) == int and level in (0,1)
        self.__dauer = level
        if self.cb_d != None: self.cb_d(self.name,level)
    def setSchnell(self,level):
        "If level = True the board will send it's clock impulses on maximum speed.\n\
Otherwise it's only a 10th as fast."
        assert type(level) == bool or type(level) == int and level in (0,1)
        self.__schnell = level
        if self.cb_s != None: self.cb_s(self.name,level)
    def setInput(self,bitnr,level):
        "Sets one bit of the input to a specific level"
        assert type(bitnr) == int and 0 <= bitnr <= 7
        assert type(level) == bool or type(level) == int and level in (0,1)
        v = self.__reg.getValue()   #Get value and change it:
        if level: v |= 2**bitnr     #Set the bit or
        else: v ^= 2**bitnr         #unset it
        self.__reg.setValue(v)      #Set the changed value

    def taktflanke(self,level):
        """If level is True HS will enable the clock-signale.
Otherwise it'll disable it."""
        if self.cb_t != None and not self.z_reset: self.cb_t(self.name,level)

    def takt(self,fromthread=False,time=None):
        """"Executes a whole clock-cycle.
fromthread is for intern use only. Is True if ther shall be special precautionary measures for threading.
time gives a special time, how long the clock-cycle shall be.
time may be a float or int. It'll be interpreted as seconds."""
        #Takt steigende Flanke:
        if fromthread: self.tL.acquire()
        self.taktflanke(1)
        if fromthread: self.tL.release()
        t1 = t2 = process_time()
        while t2-t1 <= self._getSec() if time == None else time:
            sleep(0.01)
            t2 = process_time()
        #Takt fallende Flanke:
        if fromthread: self.tL.acquire()
        self.taktflanke(0)
        if fromthread: self.tL.release()
        t1 = t2 = process_time()
        while t2-t1 <= self._getSec() if time == None else time:
            sleep(0.01)
            t2 = process_time()        

    def _getSec(self):
        "For intern use only.\nReturns the time for a half clock-cycle in seconds."
        global TAKT
        return 1/(TAKT*2) if self.__schnell else 10/(TAKT*2)
        #SEC = MS/1000
        #return SEC
    def mainloop(self):
        "Start the boards mainloop, so that automatic clock impulses are possible.\n\
please also start the mainloop if there shall not be any automatic clock impulses at the moment but maybe later.\n\
The Runtume will return because the mainloop is executed in a singel thread."
        self.t = Thread(target=self._mainloop)
        self.t.start()

    def _mainloop(self):
        "For intern use only!"
        while not self.exit:
            if self.__dauer: # not self.__hand and
                self.takt(fromthread=1) #Für Threadsichere Callbacks
            else:sleep(0.05)
        self.exit = 0
        self.t = None

    def quit(self):
        "Ends the mainloop thread."
        self.exit = 1

    def _ignore(self,*spam,**foo):
        "Intern function to have a passing method that swallowes all kind of parameters."
        pass
