#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from SwitchCanvas import SwitchCanvas as SC
import tkinter as tk
from tkinter import messagebox as MB

ABOUTTXT = """BonSim - The Bonsai Simulation v2.1

Diese Simulation wurde von Rouven Bauer als Facharbeit geschrieben.

Dieses Programm steht unter der GNU General Public License.
Genaueres dazu steht im beiliegenden Lizenttext "COPYING.txt"
oder unter "Info -> Lizenz".

Für Fragen und Anregungen:
Kontakt: rouvenbauer@gmx.de"""

LIZENZTXT ="BonSim - The Bonsai Simulation v2.1\n\
Copyright 2010 Rouven Bauer\n\
\n\
\"BonSim - The Bonsai Simulation\" is free software: you can redistribute it and/or modify \
it under the terms of the GNU General Public License as published by \
the Free Software Foundation, either version 3 of the License, or \
(at your option) any later version.\n\
\n\
\"BonSim - The Bonsai Simulation\" is distributed in the hope that it will be useful, \
but WITHOUT ANY WARRANTY; without even the implied warranty of \
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License \
along with \"BonSim - The Bonsai Simulation\".  If not, see <http://www.gnu.org/licenses/>."

class OverView(tk.Tk):
    def __init__(self, cb=None, cb_speicher=None,  screenName=None, baseName=None, className='Tk', useTk=1, sync=0, use=None):
        """Creates a tk.Tk
wich shows the whole Bonsai-Computer but in very low resolution.
Input:
cb: func - The function that shall be called if one of the boards is clicked.
parameters of callback: (board)
board is an int between 0 and 5.
      0 for 'Speicher', 1 for 'PC', 2 for 'BR',
      3 for 'Akku'    , 4 for 'HS', 5 for 'SW'."""
        tk.Tk.__init__(self,screenName,baseName,className,useTk,sync,use)
        self.cb = cb
        self.cbS = cb_speicher
        self.menu = tk.Menu(self,tearoff=0)
        self.menu.add_command(label='Speicher',command=self._cb_speicher)

        self.infomenu = tk.Menu(self.menu,tearoff=0)
        self.infomenu.add_command(label='About',command=lambda:MB.showinfo('About',ABOUTTXT))
        self.infomenu.add_command(label='Lizenz',command=lambda:MB.showinfo('Lizenz',LIZENZTXT))

        self.menu.add_cascade(label="Info",menu=self.infomenu)
        self.config(menu=self.menu)
        self.geometry('726x502')
        self.resizable(0,0)
        self.title('Bonsai-OverView')
        self.P = tk.PhotoImage(file='src/overview/Gesamt_off.gif')
        self.C = tk.Canvas(self,width=754,height=500,border=-2)
        self.C.create_image(0,0,image=self.P,anchor='nw')
        self.C.place(x=1,y=1)
        #Speicher
        self.SC_Speicher = SC('src/overview/Speicher_off.gif','src/overview/Speicher_on.gif',[ 29, 10, 34, 15,
                                                                                               33, 10, 38, 15,
                                                                                               37, 10, 43, 15,
                                                                                               42, 10, 48, 15,
                                                                                               47, 10, 52, 15,
                                                                                               51, 10, 56, 15,
                                                                                               55, 10, 60, 15,
                                                                                               59, 10, 64, 15,
                                                                                                0,  0,  0,  0, #Die Jumper sind zu klein
                                                                                                0,  0,  0,  0, #Der Unterschied ist 
                                                                                                0,  0,  0,  0, #nicht/kaum zu erkennen.
                                                                                               82, 71, 91, 79,
                                                                                               82, 78, 91, 85,
                                                                                               11, 80, 26, 97,
                                                                                               10, 98, 26,113,
                                                                                               27, 84, 35, 92,
                                                                                               34, 84, 39, 92,
                                                                                               38, 84, 44, 92,
                                                                                               43, 84, 48, 92,
                                                                                               47, 84, 52, 92,
                                                                                               51, 84, 57, 92,
                                                                                               56, 84, 61, 92,
                                                                                               60, 84, 67, 92], master = self.C)
        self.SC_Speicher.bind('<Button-1>',self._cb_Speicher)
        self.SC_Speicher.part_bind('all','<Button-1>',20*(self._cb_Speicher,))
        self.SC_Speicher.place(x=217,y=68)
        #PC
        self.SC_PC = SC('src/overview/PC_off.gif','src/overview/PC_on.gif',[ 14, 32, 23, 40,
                                                                             22, 23, 30, 40,
                                                                             47, 37, 53, 45,
                                                                             52, 37, 57, 45,
                                                                             56, 37, 62, 45,
                                                                             61, 37, 66, 45,
                                                                             65, 37, 71, 45,
                                                                             70, 37, 75, 45,
                                                                             74, 37, 79, 45,
                                                                             78, 37, 84, 45,
                                                                             68, 91, 78, 99,
                                                                             68, 98, 78,105,
                                                                             16,126, 32,143,
                                                                             31,126, 48,143,
                                                                             47,126, 63,143], master=self.C)
        self.SC_PC.bind('<Button-1>',self._cb_PC)
        self.SC_PC.part_bind('all','<Button-1>',15*(self._cb_PC,))
        self.SC_PC.place(x=354,y=68)
        #BR
        self.SC_BR = SC('src/overview/BR_off.gif','src/overview/BR_on.gif',[ 53, 17, 58, 23,
                                                                             57, 17, 63, 23,
                                                                             62, 17, 67, 23,
                                                                             66, 17, 72, 23,
                                                                             71, 17, 76, 23,
                                                                             76, 17, 80, 23,
                                                                             79, 17, 85, 23,
                                                                             84, 17, 90, 23,
                                                                             17, 30, 26, 39,
                                                                             48, 79, 57, 86,
                                                                              5, 89, 17, 99,
                                                                             61,129, 68,138,
                                                                             67,129, 72,138,
                                                                             71,129, 76,138,
                                                                             75,129, 82,138], master=self.C)
        self.SC_BR.bind('<Button-1>',self._cb_BR)
        self.SC_BR.part_bind('all','<Button-1>',15*(self._cb_BR,))
        self.SC_BR.place(x=491,y=71) 
        #Akku
        self.SC_Akku = SC('src/overview/Akku_off.gif','src/overview/Akku_on.gif',[ 12, 36, 19, 43,
                                                                                   18, 36, 27, 43,
                                                                                   43, 40, 50, 48,
                                                                                   49, 40, 55, 48,
                                                                                   54, 40, 59, 48,
                                                                                   58, 40, 63, 48,
                                                                                   62, 40, 67, 48,
                                                                                   66, 40, 72, 48,
                                                                                   71, 40, 76, 48,
                                                                                   75, 40, 81, 48,
                                                                                   64, 92, 74,100,
                                                                                   64, 99, 74,106,
                                                                                   14,127, 28,143,
                                                                                   29,128, 43,143,
                                                                                   44,127, 58,143], master=self.C)
        self.SC_Akku.bind('<Button-1>',self._cb_Akku)
        self.SC_Akku.part_bind('all','<Button-1>',15*(self._cb_Akku,))
        self.SC_Akku.place(x=220,y=255)
        #HS
        self.SC_HS = SC('src/overview/HS_off.gif','src/overview/HS_on.gif',[ 54, 42, 62, 49,
                                                                             11, 54, 20, 65,
                                                                             20, 55, 29, 65,
                                                                             29, 55, 37, 65,
                                                                             37, 55, 46, 65,
                                                                             46, 55, 55, 65,
                                                                             55, 55, 63, 65,
                                                                             64, 55, 72, 65,
                                                                             73, 55, 81, 65,
                                                                             75, 65, 81, 71,
                                                                              5, 82, 13, 93,
                                                                              5, 99, 13,110,
                                                                             15, 98, 28,113,
                                                                             64,100, 77,109,
                                                                             15,125, 30,141], master=self.C)
        self.SC_HS.bind('<Button-1>',self._cb_HS)
        self.SC_HS.part_bind('all','<Button-1>',15*(self._cb_HS,))
        self.SC_HS.place(x=356,y=258)
        #SW
        self.SC_SW = SC('src/overview/SW_off.gif','src/overview/SW_on.gif',[ 52, 20, 60, 29,# 0
                                                                             69, 40, 73, 44,# 1
                                                                             48, 43, 52, 46,# 2
                                                                             69, 43, 73, 46,# 3
                                                                             72, 43, 75, 46,# 4
                                                                             46, 45, 50, 49,# 5
                                                                             49, 45, 52, 49,# 6
                                                                             69, 45, 73, 49,# 7
                                                                             74, 47, 78, 50,# 8
                                                                             48, 49, 52, 53,# 9
                                                                             57, 49, 61, 53,#10
                                                                             74, 49, 73, 53,#11
                                                                             52, 51, 56, 55,#12
                                                                             74, 52, 77, 55,#13
                                                                             76, 51, 80, 55,#14
                                                                             43, 53, 47, 57,#15
                                                                             50, 53, 54, 57,#16
                                                                             58, 53, 62, 57,#17
                                                                             73, 54, 77, 57,#18
                                                                             73, 56, 77, 59,#19
                                                                             48, 62, 52, 66,#20
                                                                             56, 62, 60, 66,#21
                                                                             73, 62, 77, 65,#22
                                                                             54, 64, 58, 68,#23
                                                                             73, 64, 76, 68,#24
                                                                             75, 64, 79, 68,#25
                                                                             44, 66, 48, 69,#26
                                                                             50, 66, 59, 70,#27
                                                                             58, 66, 62, 69,#28
                                                                             73, 67, 77, 70,#29
                                                                             44, 68, 48, 72,#30
                                                                             67, 68, 71, 72,#31
                                                                             73, 68, 77, 72,#32
                                                                             73, 71, 77, 75,#33
                                                                             47, 73, 51, 76,#34
                                                                             73, 74, 77, 77,#35
                                                                             76, 73, 80, 77,#36
                                                                             44, 74, 48, 78,#37
                                                                             47, 75, 51, 78,#38
                                                                             73, 76, 78, 75,#39
                                                                             78, 75, 82, 79,#40
                                                                             12,104, 18,110,#41
                                                                             17,104, 22,110,#42
                                                                             21,104, 26,110,#43
                                                                             25,104, 31,110,#44
                                                                             34,104, 43,111,#45
                                                                             13,131, 19,137,#46
                                                                             17,132, 23,137,#47
                                                                             22,131, 27,137,#48
                                                                             26,131, 31,137,#49
                                                                             30,131, 36,137,#50
                                                                             35,131, 40,137,#51
                                                                             39,131, 44,137,#52
                                                                             43,131, 48,137,#53
                                                                             47,131, 52,137,#54
                                                                             51,131, 57,137,#55
                                                                             56,131, 61,137,#56
                                                                             60,131, 65,137,#57
                                                                             64,131, 69,137,#58
                                                                             68,131, 74,137,#59
                                                                             73,131, 78,137,#60
                                                                             77,131, 82,137], master=self.C) #61
        self.SC_SW.bind('<Button-1>',self._cb_SW)
        self.SC_SW.part_bind('all','<Button-1>',61*(self._cb_SW,))
        self.SC_SW.place(x=490,y=255)
        
        self.SCs = [self.SC_Speicher,self.SC_PC,self.SC_BR,self.SC_Akku,self.SC_HS,self.SC_SW]

    def _cb_speicher(self):
        """Intern use only.
Handles clicks on the windowmenu-label \"Speicher\""""
        if self.cbS != None: self.cbS()

    def set(self, board, part, level):
        """Set a part of a board to a level
board is the board on which the part is;
part is the part on the SwitchCanvas that showes the thing to change and
level is a boolean with the logical status of the button."""
        if level: self.SCs[board].setOn(part)
        else:     self.SCs[board].setOff(part)

    def _cb_Speicher(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf Speicher geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(0)
    def _cb_PC(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf PC geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(1)
    def _cb_BR(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf BR geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(2)
    def _cb_Akku(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf Akku geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(3)
    def _cb_HS(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf HS geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(4)
    def _cb_SW(self,*foo):
        """Intern function.
Wird aufgerufen, wenn auf SW geklickt wurde.
Wandelt die Form des Cb's um und leitet ihn weiter."""
        if self.cb != None: self.cb(5)

if __name__ == '__main__':
    ov = OverView(print)
    ov.mainloop()
