#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

import tkinter as tk
from tkinter import messagebox as mb

class MemoryDialog:
    def ask(master, toinsert=[], **kw):
        """Opens a dialog.
The dialog asks the user for some data content for the memory.

Input:
master - tkinter.Tk.
toinsert - list of integers. The current data content of the memory.
**kw are passed directly to tk.Toplevel.

The Dialog looks like this:
 ___________________
|            _ [] X |
''''''''''''''''''_''
|  1 [__________]|^||
|  2 [__________]|_||
|  4 [__________]| ||
|  5 [__________]|=||
|  6 [__________]|_||
|  7 [__________]| ||
|  8 [__________]| ||
|  9 [__________]| ||
| 10 [__________]| ||
| 11 [__________]|_||
| 12 [__________]|v||
'''''''''''''''''''''"""
        if len(toinsert) > 256:
            raise TypeError('toinsert is too long.\n Must be at most 256 bytes long')
        for i in range(len(toinsert)):
            if not (type(toinsert[i]) == str and len(toinsert[i]) <= 8 and 0 <= int(toinsert[i],2) <= 256):
                raise TypeError(str(toinsert[i])+' is an invalid input vor Memoryvalue.\n Must be a binary with at most 8 didgets!')
            toinsert[i] = '0'*(8-len(toinsert[i]))+toinsert[i]
            if toinsert[i] == '0'*8:
                toinsert[i] = ''
        toinsert += ['']*(256-len(toinsert))
        subm = tk.BooleanVar(False)
        #subm.set(False)
        end = tk.BooleanVar(False)
        #end.set(False)
        top = tk.Toplevel(master, **kw)
        top.withdraw()
        top.deiconify()
        top.transient(master)
        top.grab_set()
        top.bind('<Key-Return>',lambda event:subm.set(True))
        top.protocol('WM_DELETE_WINDOW',lambda:end.set(True))
        #Submit-Button
        b = tk.Button(top,text='OK',command=lambda:subm.set(True))
        b.grid(row=1,column=0,columnspan=2)
        #Scrollbar
        ysb = tk.Scrollbar(top)
        ysb.grid(row=0,column=1,sticky='NS')
        #Canvas
        c = tk.Canvas(top,relief='flat',width=100,
                      height=300,yscrollcommand=ysb.set)
        c.grid(row=0,column=0)
        #Statify Dialog-size
        top.update_idletasks()
        top.resizable(False,False)
        #Config Scrollbar
        ysb.config(command=c.yview)
        #Frame
        f = tk.Frame(c)
        f.grid(row=0,column=0,sticky='NSWE')
        #Fill Frame
        lI = []
        for i in range(256):
            tk.Label(f,text=str(i)).grid(row=i,column=0,sticky='E')
            lI += [tk.Entry(f,width=9,justify='right')]
            lI[-1].insert(0,toinsert[i])
            lI[-1].grid(row=i,column=1,sticky='WE')
        #Config Canvas
        c.create_window(0, 0, anchor='nw', window=f)
        f.update_idletasks()
        c.config(scrollregion=c.bbox("all"))
        while True:
            top.update()
            if subm.get() or end.get():
                assert subm.get() ^ end.get()
                if subm.get():
                    get = []
                    try:
                        for i in lI:
                            got = i.get()
                            get += [int(got if got != '' else '0',2)]
                            assert 0 <= get[-1] <= 255
                        break
                    except:
                        mb.showwarning('Invalide Eingabe','Invalide Eingabe in Feld '+str(lI.index(i))+':\n'+i.get()+'\nBitte nur Binärzahlen zwischen 0 und 255 eingeben!')
                        subm.set(False)
                        continue
                else:
                    get = None
                    break
        top.destroy()
        return get
    
    ask = staticmethod(ask)

        

from tkinter import simpledialog
def main():
    root = tk.Tk()
    b = tk.Button(root, text='Show', command=lambda:print(MemoryDialog.ask(root)))
    b.pack()
    root.mainloop()

if __name__ == '__main__':
    main()
