from tkinter import *
import pickle   # Serialisierung von Objekten zur Speicherung

class Benutzer(object):
    def __init__(self, Name, Vorname, GebDat):
        self.Name       = Name
        self.Vorname  = Vorname
        self.GebDat = GebDat




class Speicher(object):
    def __init__(self):

        self.dateiname = "gbuch.bin"
        print('Datei ', self.dateiname, ' geöffnet.')
        try:
            self.datei = open(self.dateiname, 'r+b')
        except IOError:  # Datei existiert noch nicht --> Neuanlage
            self.datei = open(self.dateiname, 'wb')
            self.datei.close()
            self.datei = open(self.dateiname, 'r+b')


    def Ende(self):
        print('Datei ', self.dateiname, ' geschlossen.')
        if self.datei:
            self.datei.close()



    def LeseDatensatz(self):
        try:
            gelesen = pickle.load(self.datei)
        except Exception as e:  # Datensatz nicht gefunden
            gelesen = Benutzer("","","")

        return gelesen

    def SpringeAnfang(self):
        self.datei.seek(0)


    def SchreibeDatensatz(self,neuerBenutzer):
        self.datei.seek(0,2)  # Sprung an das Dateiende
        pickle.dump(neuerBenutzer, self.datei)
        self.datei.flush()
    










    
def Button_Weiter_Click():
    gelesen = meinSpeicher.LeseDatensatz()
    entryName.delete(0,END)
    entryName.insert(0,gelesen.Name)
    entryVorname.delete(0,END)
    entryVorname.insert(0,gelesen.Vorname)
    entryGebDat.delete(0,END)
    entryGebDat.insert(0,gelesen.GebDat)


def Button_Anfang_Click():
    meinSpeicher.SpringeAnfang()
    Button_Weiter_Click()
    


def Button_Speichern_Click():
    Name    = entryName.get()
    Vorname = entryVorname.get()
    GebDat  = entryGebDat.get()
    neuerBenutzer = Benutzer(Name, Vorname, GebDat)
    meinSpeicher.SchreibeDatensatz(neuerBenutzer)
    entryName.delete(0,END)
    entryVorname.delete(0,END)
    entryGebDat.delete(0,END)




def winexit():
    meinSpeicher.Ende()
    tkFenster.destroy()
    tkFenster.quit()





# Erzeugung des Fensters
tkFenster = Tk()
tkFenster.title("GBuch")
tkFenster.geometry("270x160")

tkFenster.protocol("WM_DELETE_WINDOW", winexit) # Exit wenn x gedrückt



# Rahmen Daten
frameDaten = Frame(master=tkFenster, \
                   background="#A0DAB3")
frameDaten.place(x=10, y=10, width=250, height=100)

labelName = Label(master=frameDaten, \
                  text="Name", \
                  background="#A0DAB3", \
                  anchor=W)
labelName.place(x=5, y=5, width=100, height=20)
entryName = Entry(master=frameDaten, \
                  background="white")
entryName.place(x=100, y=5, width=100, height=20)


labelVorname = Label(master=frameDaten, \
                       text="Vorname", \
                       background="#A0DAB3", \
                       anchor=W)
labelVorname.place(x=5, y=35, width=100, height=20)
entryVorname = Entry(master=frameDaten, \
                       background="white")
entryVorname.place(x=100, y=35, width=100, height=20)



labelGebDat = Label(master=frameDaten, \
                        text="GebDat", \
                        background="#A0DAB3", \
                        anchor=W)
labelGebDat.place(x=5, y=65, width=100, height=20)
entryGebDat = Entry(master=frameDaten, \
                        background="white")
entryGebDat.place(x=100, y=65, width=100, height=20)


# Rahmen Buttons
frameButtons = Frame(master=tkFenster, \
                     background="#FFDA5D")
frameButtons.place(x=10, y=120, width=250, height=30)

buttonAnfang = Button(master=frameButtons, \
                      text="Anfang", \
                      command=Button_Anfang_Click)
buttonAnfang.place(x=5, y=5, width=50, height=20)
buttonWeiter = Button(master=frameButtons, \
                      text="weiter", \
                      command=Button_Weiter_Click)
buttonWeiter.place(x=60, y=5, width=50, height=20)
buttonSpeichern = Button(master=frameButtons, \
                         text="Datensatz speichern", \
                         command=Button_Speichern_Click)
buttonSpeichern.place(x=120, y=5, width=120, height=20)

# Aktivierung des Fensters
meinSpeicher = Speicher()

tkFenster.mainloop()
