from tkinter import *
from xml.dom.minidom import *




class Speicher(object):
    def __init__(self):
        self.domimpl = getDOMImplementation()

        self.dateiname = "gbuch_attribute.xml"
        try:
            self.xmlBaum = parse(self.dateiname)
        except:  # Datei existiert noch nicht --> Neuanlage
            self.xmlBaum = self.domimpl.createDocument(None, "gbuch", None)

        self.AlleBenutzer = self.xmlBaum.getElementsByTagName("benutzer")
        self.aktDatensatz = 0
        print('Datei ', self.dateiname, ' verwendet.')
        

    def Ende(self):
        print('Ende')


    def LeseDatensatz(self):
        if len(self.AlleBenutzer)>0 and self.aktDatensatz < len(self.AlleBenutzer):  
            xmlBenutzer = self.AlleBenutzer[self.aktDatensatz]
            Name    = xmlBenutzer.getAttribute("name")
            Vorname = xmlBenutzer.getAttribute("vorname")
            GebDat  = xmlBenutzer.getAttribute("gebdat")
            self.aktDatensatz = self.aktDatensatz+1
        else:
            Name = Vorname = GebDat = ""
        return Name, Vorname, GebDat




    def SpringeAnfang(self):
        self.aktDatensatz=0


    def xmlKnotenMitText(self,tagname, taginhalt):
        xmlKnoten = self.xmlBaum.createElement(tagname)
        xmlKnoten.appendChild(self.xmlBaum.createTextNode(taginhalt))
        return xmlKnoten


    def SchreibeDatensatz(self,Name,Vorname,GebDat):
        # XML-Struktur erweitern
        xmlBenutzer = self.xmlBaum.createElement("benutzer")
        xmlBenutzer.setAttribute("name", Name)
        xmlBenutzer.setAttribute("vorname", Vorname)
        xmlBenutzer.setAttribute("gebdat", GebDat)
        self.xmlBaum.documentElement.appendChild(xmlBenutzer)

        # Schreibe komplette XML-Datei neu (ja, das geht auch "schöner" ;-)
        datei = open(self.dateiname,"w")
        self.xmlBaum.writexml(datei, encoding="iso-8859-1")
        datei.close()

        self.AlleBenutzer=self.xmlBaum.getElementsByTagName("benutzer")






    
def Button_Weiter_Click():
    Name,Vorname,GebDat = meinSpeicher.LeseDatensatz()        
    entryName.delete(0,END)
    entryName.insert(0,Name)
    entryVorname.delete(0,END)
    entryVorname.insert(0,Vorname)
    entryGebDat.delete(0,END)
    entryGebDat.insert(0,GebDat)


def Button_Anfang_Click():
    meinSpeicher.SpringeAnfang()
    Button_Weiter_Click()
    


def Button_Speichern_Click():
    Name    = entryName.get()
    Vorname = entryVorname.get()
    GebDat  = entryGebDat.get()
    meinSpeicher.SchreibeDatensatz(Name,Vorname,GebDat)
    entryName.delete(0,END)
    entryVorname.delete(0,END)
    entryGebDat.delete(0,END)






def winexit():
    meinSpeicher.Ende()
    tkFenster.destroy()
    tkFenster.quit()





# Erzeugung des Fensters
tkFenster = Tk()
tkFenster.title("GBuch")
tkFenster.geometry("270x160")

tkFenster.protocol("WM_DELETE_WINDOW", winexit) # Exit wenn x gedrückt


# Rahmen Daten
frameDaten = Frame(master=tkFenster, \
                   background="#A0DAB3")
frameDaten.place(x=10, y=10, width=250, height=100)

labelName = Label(master=frameDaten, \
                  text="Name", \
                  background="#A0DAB3", \
                  anchor=W)
labelName.place(x=5, y=5, width=100, height=20)
entryName = Entry(master=frameDaten, \
                  background="white")
entryName.place(x=100, y=5, width=100, height=20)


labelVorname = Label(master=frameDaten, \
                       text="Vorname", \
                       background="#A0DAB3", \
                       anchor=W)
labelVorname.place(x=5, y=35, width=100, height=20)
entryVorname = Entry(master=frameDaten, \
                       background="white")
entryVorname.place(x=100, y=35, width=100, height=20)



labelGebDat = Label(master=frameDaten, \
                        text="GebDat", \
                        background="#A0DAB3", \
                        anchor=W)
labelGebDat.place(x=5, y=65, width=100, height=20)
entryGebDat = Entry(master=frameDaten, \
                        background="white")
entryGebDat.place(x=100, y=65, width=100, height=20)


# Rahmen Buttons
frameButtons = Frame(master=tkFenster, \
                     background="#FFDA5D")
frameButtons.place(x=10, y=120, width=250, height=30)

buttonAnfang = Button(master=frameButtons, \
                      text="Anfang", \
                      command=Button_Anfang_Click)
buttonAnfang.place(x=5, y=5, width=50, height=20)
buttonWeiter = Button(master=frameButtons, \
                      text="weiter", \
                      command=Button_Weiter_Click)
buttonWeiter.place(x=60, y=5, width=50, height=20)
buttonSpeichern = Button(master=frameButtons, \
                         text="Datensatz speichern", \
                         command=Button_Speichern_Click)
buttonSpeichern.place(x=120, y=5, width=120, height=20)

# Aktivierung des Fensters

meinSpeicher = Speicher()

tkFenster.mainloop()
