from tkinter import *

# Bibliothek zum Zugriff auf eine MySQL-Datenbank
# http://dev.mysql.com/downloads/connector/python/
import mysql.connector

"""
--
-- Tabellenstruktur und Beispieldaten für Tabelle benutzer
--

CREATE TABLE benutzer (
  Name VARCHAR(30) NOT NULL,
  Vorname VARCHAR(30) NOT NULL,
  GebDat DATE  NOT NULL
);


INSERT INTO benutzer (Name, Vorname, GebDat) VALUES
('Winkelmann', 'Paul', '1980-10-02'),
('Lindemann', 'Erwin', '1971-09-18'),
('Hallmackenreuther', 'Ernst ', '1987-03-10');
"""


class Speicher(object):
    def __init__(self):

        self.Datenbank='meingbuch'
        try:
            # Hier kann die DB-Verbindung angegeben werden
            self.dbcon = mysql.connector.connect(
                            user     = 'root',
                            password = 'sql',
                            host     = 'localhost',
                            database = 'meingbuch')
            self.dateiname = "gbuch.dat"
            print('Datenbank ', self.Datenbank, ' verbunden.')
            self.SQLText= "SELECT Name, Vorname, GebDat " \
                          "  FROM benutzer "

            self.cursor = self.dbcon.cursor(buffered=True) # Nicht gepufferte Cursor können nicht zu jederzeit geschlossen werden.
            self.cursor.execute(self.SQLText)

        except mysql.connector.Error as err:
            print(err)



    def Ende(self):
        print('Datenbank ', self.Datenbank, ' geschlossen.')
        if self.dbcon:
            self.dbcon.close()


    def LeseDatensatz(self):
        row = self.cursor.fetchone()
        Name = Vorname = GebDat = ""
        if row:
            if row[0]: # falls NULL-Werte zurückkommen
                Name    = row[0]
            if row[1]:
                Vorname = row[1]
            if row[2]:
                GebDat  = row[2]
        return Name, Vorname, GebDat


    def SpringeAnfang(self):
        # Cursor schließen und wieder aufmachen
        self.cursor.execute(self.SQLText)


    def SchreibeDatensatz(self,Name,Vorname,GebDat):
        InsertSQL = "INSERT INTO benutzer VALUES ('%s', '%s', '%s')" % (Name, Vorname, GebDat)
        try:
            insertstmt = self.dbcon.cursor()
            insertstmt.execute(InsertSQL)
            self.dbcon.commit()
        except mysql.connector.Error as err:
            print(err)
        self.SpringeAnfang()






    
def Button_Weiter_Click():
    Name, Vorname, GebDat = meinSpeicher.LeseDatensatz()
    entryName.delete(0,END)
    entryName.insert(0,Name)
    entryVorname.delete(0,END)
    entryVorname.insert(0,Vorname)
    entryGebDat.delete(0,END)
    entryGebDat.insert(0,GebDat)


def Button_Anfang_Click():
    meinSpeicher.SpringeAnfang()
    Button_Weiter_Click()

    


def Button_Speichern_Click():
    Name     = entryName.get()
    Vorname  = entryVorname.get()
    GebDat   = entryGebDat.get()
    meinSpeicher.SchreibeDatensatz(Name,Vorname,GebDat)
    entryName.delete(0,END)
    entryVorname.delete(0,END)
    entryGebDat.delete(0,END)


def winexit():
    meinSpeicher.Ende()
    tkFenster.destroy()
    tkFenster.quit()





# Erzeugung des Fensters
tkFenster = Tk()
tkFenster.title("GBuch")
tkFenster.geometry("270x160")

tkFenster.protocol("WM_DELETE_WINDOW", winexit) # Exit wenn x gedrückt



# Rahmen Daten
frameDaten = Frame(master=tkFenster, \
                   background="#A0DAB3")
frameDaten.place(x=10, y=10, width=250, height=100)

labelName = Label(master=frameDaten, \
                  text="Name", \
                  background="#A0DAB3", \
                  anchor=W)
labelName.place(x=5, y=5, width=100, height=20)
entryName = Entry(master=frameDaten, \
                  background="white")
entryName.place(x=100, y=5, width=100, height=20)


labelVorname = Label(master=frameDaten, \
                       text="Vorname", \
                       background="#A0DAB3", \
                       anchor=W)
labelVorname.place(x=5, y=35, width=100, height=20)
entryVorname = Entry(master=frameDaten, \
                       background="white")
entryVorname.place(x=100, y=35, width=100, height=20)



labelGebDat = Label(master=frameDaten, \
                        text="GebDat", \
                        background="#A0DAB3", \
                        anchor=W)
labelGebDat.place(x=5, y=65, width=100, height=20)
entryGebDat = Entry(master=frameDaten, \
                        background="white")
entryGebDat.place(x=100, y=65, width=100, height=20)


# Rahmen Buttons
frameButtons = Frame(master=tkFenster, \
                     background="#FFDA5D")
frameButtons.place(x=10, y=120, width=250, height=30)

buttonAnfang = Button(master=frameButtons, \
                      text="Anfang", \
                      command=Button_Anfang_Click)
buttonAnfang.place(x=5, y=5, width=50, height=20)
buttonWeiter = Button(master=frameButtons, \
                      text="weiter", \
                      command=Button_Weiter_Click)
buttonWeiter.place(x=60, y=5, width=50, height=20)
buttonSpeichern = Button(master=frameButtons, \
                         text="Datensatz speichern", \
                         command=Button_Speichern_Click)
buttonSpeichern.place(x=120, y=5, width=120, height=20)



# Aktivierung des Fensters
meinSpeicher = Speicher()
tkFenster.mainloop()
