# Konstanten: Grenzen der Karte in Grad
cNord = 55.1
cSued = 47.2
cWest = 5.5
cOst  = 15.5



# Daten in Datenbankgespeichert in Grad (keine Minuten, sondern Gradanteile)
# d.h. 60.5 sind also 60° und 30'
def InPixelNS(bild, grad):
  """ Umrechnung Geokoordinate in Bildkoordinate. Übergabe: Bild (für dessen Höhe) und Breitengrad """
  erg=bild.height()-round((grad-cSued)*bild.height()/(cNord-cSued))
  return erg

def InPixelWO(bild, grad):
  """ Umrechnung Geokoordinate in Bildkoordinate. Übergabe: Bild (für dessen Breite) und Längengrad """
  erg = round((grad-cWest)* bild.width()/(cOst-cWest))
  return erg



# http://dev.mysql.com/downloads/connector/python/
import mysql.connector

# Importiere alles aus der tkInter-Bibliothek (Fensterverwaltung)
from tkinter import *


# Erzeuge Fenster und Canvas mit Hintergrundbild
root = Tk ( )
root.title("Städte in Deutschland")

# Laden einer "quadratischen Plattkarte", bei der die Geokoordinaten zumindest rechteckig
# (und damit verzerrt!) angeordnet sind.
# zu finden u.a. bei https://de.wikipedia.org/wiki/Wikipedia:Kartenwerkstatt/Positionskarten
bgBild = PhotoImage(file="Deutschland.gif")
# Alternativ: Relief-Bild als PNG
#bgBild = PhotoImage(file="DeutschlandRelief.png")
leinwand=Canvas(root, width=bgBild.width(), height=bgBild.height())
leinwand.create_image(0,0,image=bgBild,anchor="nw")



### Hier muss die Abfrage der Daten aus der Datenbank geschehen
## Hilfe:

# Zeichnen eines Kreises
radius = 10
leinwand.create_oval(20,50, 20+radius,  50+radius, fill = "blue")
# Zeichnen einer Beschriftung
leinwand.create_text(20,70, text="Über mir wurde ein blauer Kreis gezeichnet", fill='red', anchor="nw")




leinwand.pack()
root.mainloop()

