--
-- Tabellenstruktur für Tabelle 'fahrlehrer'
--

CREATE TABLE IF NOT EXISTS fahrlehrer (
  FNR     integer NOT NULL,
  Vorname varchar(30) DEFAULT NULL,
  Name    varchar(30) DEFAULT NULL,
  PRIMARY KEY (FNR)
);

--
-- Daten für Tabelle 'fahrlehrer'
--

INSERT INTO fahrlehrer (FNR, Vorname, Name) VALUES (11, 'Klaus', 'Uhr');
INSERT INTO fahrlehrer (FNR, Vorname, Name) VALUES (12, 'Marta', 'Pfahl');

--
-- Tabellenstruktur für Tabelle 'fahrstunde'
--

CREATE TABLE IF NOT EXISTS fahrstunde (
  SNR      integer NOT NULL,
  Datum    date,
  Zeit     time,
  FNR      integer,
  PRIMARY KEY (SNR,Datum)
);

--
-- Daten für Tabelle 'fahrstunde'
--

INSERT INTO fahrstunde (SNR, Datum, Zeit, FNR) VALUES (43, '2016-07-04', NULL, 11);

--
-- Tabellenstruktur für Tabelle 'schueler'
--

CREATE TABLE IF NOT EXISTS schueler (
  SNR          integer NOT NULL,
  Vorname      varchar(30),
  Name         varchar(50),
  BevorzugtFNR integer,
  PRIMARY KEY (SNR)
);

--
-- Daten für Tabelle 'schueler'
--

INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (42, 'Andi', 'Macht', NULL);
INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (43, 'Eddi', 'Kett', NULL);
INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (44, 'Farin', 'Urlaub', NULL);
INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (45, 'Sunny', 'Täter', 12);
INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (46, 'Volker', 'Racho', NULL);
INSERT INTO schueler (SNR, Vorname, Name, BevorzugtFNR) VALUES (47, 'André', 'Richtung', NULL);

--
-- Constraints der Tabelle fahrstunde - können erst nach dem Einfügen der Daten angelegt werden
--
ALTER TABLE fahrstunde
  ADD CONSTRAINT fahrstunde_ibfk_1 FOREIGN KEY (SNR) REFERENCES schueler (SNR),
  ADD CONSTRAINT fk_fahrstunde_fahrlehrer1 FOREIGN KEY (FNR) REFERENCES fahrlehrer (FNR);

--
-- Constraints der Tabelle schueler
--
ALTER TABLE schueler
  ADD CONSTRAINT fk_schueler_fahrlehrer1 FOREIGN KEY (BevorzugtFNR) REFERENCES fahrlehrer (FNR);

