# Namen der Token

tokens = ['ZAHL', 'INC', 'DEC', 'JMP', 'TST', 'HLT', 'DP', 'KO']

# Beschreibung der Token

t_ZAHL  = r'0|[1-9][0-9]*'
t_INC   = r'inc'
t_DEC   = r'dec'
t_JMP   = r'jmp'
t_TST   = r'tst'
t_HLT   = r'hlt'
t_DP    = r':'
t_KO    = r'\#'

# Ignorierte Zeichen
t_ignore = " \t"

def t_newline(t):
    r'\n+'
    t.lexer.lineno = t.lexer.lineno + t.value.count("\n")

def t_error(t):
    print("Illegal character '%s'" % t.value[0])
    t.lexer.skip(1)

# erweiterte Produktionen

def p_programm_anweisungsfolge_speicherbelegung(p):
    'programm : anweisungsfolge speicherbelegung'
    p[0] = [p[1], p[2]]

def p_anweisungsfolge_anweisung_anweisungsfolge(p):
    'anweisungsfolge : anweisung anweisungsfolge'
    p[0] = [p[1]] + p[2]

def p_anweisungsfolge_anweisung(p):
    'anweisungsfolge : anweisung'
    p[0] = [p[1]]

def p_anweisung_inc(p):
    'anweisung : ZAHL DP INC ZAHL'
    p[0] = (eval(p[1]), p[3], eval(p[4]))

def p_anweisung_dec(p):
    'anweisung : ZAHL DP DEC ZAHL'
    p[0] = (eval(p[1]), p[3], eval(p[4]))

def p_anweisung_jmp(p):
    'anweisung : ZAHL DP JMP ZAHL'
    p[0] = (eval(p[1]), p[3], eval(p[4]))

def p_anweisung_tst(p):
    'anweisung : ZAHL DP TST ZAHL'
    p[0] = (eval(p[1]), p[3], eval(p[4]))

def p_anweisung_hlt(p):
    'anweisung : ZAHL DP HLT'
    p[0] = (eval(p[1]), p[3])

def p_speicherbelegung_kommentar_anweisungsfolge(p):
    'speicherbelegung : KO ZAHL speicherbelegung'
    p[0] = [eval(p[2])] + p[3]

def p_speicherbelegung(p):
    'speicherbelegung : '
    p[0] = []


# Fehlermeldung
def p_error(p):
    print("Syntaxfehler!")



