import ply.lex as lex
import ply.yacc as yacc

class CompilerMyKa(object):
    def __init__(self):
        self.quelltext = None

    def setQuelltext(self, q):
        self.quelltext = q

    def kompilieren(self):
        tokens = ['S','R', 'L', 'ZH', 'ZA', 'MS', 'ML', 'P', 'WH_ANF', 'WH_END', 'DP', 'IF_ANF', 'IF_END', 'ELSE', 'VZ', 'NZ', 'VW', 'NW', 'AM', 'NM', 'SEM', 'KL_AUF', 'KL_ZU']

        # Token
        t_S    = r's'
        t_R    = r'r'
        t_L    = r'l'
        t_ZH    = r'zh'
        t_ZA    = r'za'
        t_MS    = r'ms'
        t_ML    = r'ml'
        t_P     = r'p'
        t_WH_ANF = r'wh'
        t_WH_END = r'\*wh'
        t_IF_ANF = r'if'
        t_IF_END = r'\*if'
        t_ELSE  = r'else'
        t_NZ    = r'nz'
        t_NW    = r'nw'
        t_VZ    = r'vz'
        t_VW    = r'vw'
        t_AM    = r'am'
        t_NM    = r'nm'
        t_SEM   = r';'
        t_KL_AUF = r'\('
        t_KL_ZU  = r'\)'
        t_DP  = r'\:'


        # Ignorierte Zeichen
        t_ignore = " \t"

        def t_newline(t):
            r'\n+'
            t.lexer.lineno = t.lexer.lineno + t.value.count("\n")

        def t_error(t):
            print("Illegal character '%s'" % t.value[0])
            t.lexer.skip(1)

        # Erzeugung des Scanners

        lexer = lex.lex(debug=0)


        # Ausgabe der Token

        lexer.input(self.quelltext)
        tok = lexer.token()
        while tok:
            print(tok)
            tok = lexer.token()


#-----------------------------------------------------------


        def p_programm(p):
            'programm : anweisungsfolge'

            p[0] = p[1]


        def p_anweisungsfolge(p):
            '''anweisungsfolge : anweisungSemikolon anweisungsfolge
                               | anweisungSemikolon'''
            if len(p) > 2:
                p[0] = [p[1]] + p[2]
            else:
                p[0] = [p[1]]

        def p_anweisungSem(p):
            '''anweisungSemikolon : anweisung SEM'''
            p[0] = p[1]

        def p_anweisung(p):
            '''anweisung : S
                         | L
                         | R
                         | ZH
                         | ZA
                         | MS
                         | ML
                         | P
                         | IF_ANF KL_AUF bedingung KL_ZU DP anweisungsfolge ELSE DP anweisungsfolge IF_END
                         | WH_ANF KL_AUF bedingung KL_ZU DP anweisungsfolge WH_END'''
            if p[1] == "if":
                p[0] = [p[1]] + [[p[3]]] + [p[6]] + [p[9]]
            elif p[1] == "wh":
                p[0] = [p[1]] + [[p[3]]] + [p[6]]
            else:
                p[0] = [p[1]]



        def p_bedingung(p):
            '''bedingung : NW
                         | NZ
                         | VW
                         | VZ
                         | AM
                         | NM'''
            p[0] = p[1]

        def p_error(p):
            if p != None:
                print("Syntax error at '%s'" % p.value)
            else:
                print("Syntax error")


        # import

        yacc.yacc(debug=True)
        if len(self.quelltext) != 0:
            return yacc.parse(self.quelltext, debug=0)
        else:
            return []

