from tkinter import *
import tkinter.filedialog

class RoboterGUI:

    def __init__(self, rob, welt, parserMyKa, interpreterMyKaList, compilerMyKaList, interpreterMyKaGoto):
        # Referenzattribute zum Datenmodell
        self.rob = rob
        self.welt = welt
        self.parserMyKa = parserMyKa
        self.interpreterMyKaList = interpreterMyKaList
        self.compilerMyKaList = compilerMyKaList
        self.interpreterMyKaGoto = interpreterMyKaGoto

        # Erzeugung des Fensters
        self.fenster = Tk()
        self.fenster.title("MyKa")
        self.fenster.geometry('620x620')
        # Farben
        blau = "#BDE2F3"
        rot = "#FFCFC9"
        gelb = "#FBD975"
        gruen = "#D5E88F"

        # MyKaRoboter
        # Rahmen
        self.rahmenRoboter = Frame(master=self.fenster, background=blau)
        self.rahmenRoboter.place(x=315, y=5, width=300, height=250)
        # Leinwand
        self.canvas = Canvas(master=self.rahmenRoboter, background="white", width=164, height=164)
        self.canvas.place(x=68, y=14)
        self.canvas.bind("<Double-Button-1>", self.canvasInitialisieren)
        self.erzeugeWeltGrafik()
        self.erzeugeRoboterGrafik()
        # Button initialisieren
        self.buttonInitialisieren = Button(master=self.rahmenRoboter, text="initialisieren", command=self.buttonInitialisierenClick)
        self.buttonInitialisieren.place(x=110, y=215, width=100, height=27)

        # MyKaSteuerung
        # Rahmen
        self.rahmenSteuerung = Frame(master=self.fenster, background=blau)
        #self.rahmenSteuerung.place(x=315, y=215, width=300, height=200)
        # Button links
        self.buttonLinks = Button(master=self.rahmenSteuerung, text="links", command=self.buttonLinksClick)
        self.buttonLinks.place(x=5, y=46, width=90, height=27)
        # Button schritt
        self.buttonSchritt = Button(master=self.rahmenSteuerung, text="schritt", command=self.buttonSchrittClick)
        self.buttonSchritt.place(x=105, y=46, width=90, height=27)
        # Button rechts
        self.buttonRechts = Button(master=self.rahmenSteuerung, text="rechts", command=self.buttonRechtsClick)
        self.buttonRechts.place(x=205, y=46, width=90, height=27)
        # Button Marke setzen
        self.buttonMarkeSetzen = Button(master=self.rahmenSteuerung, text="Marke setzen", command=self.buttonMarkeSetzenClick)
        self.buttonMarkeSetzen.place(x=5, y=86, width=90, height=27)
        # Button Marke löschen
        self.buttonMarkeLoeschen = Button(master=self.rahmenSteuerung, text="Marke loeschen", command=self.buttonMarkeLoeschenClick)
        self.buttonMarkeLoeschen.place(x=5, y=126, width=90, height=27)
        # Button Ziegel hinlegen
        self.buttonMarkeSetzen = Button(master=self.rahmenSteuerung, text="Ziegel hinlegen", command=self.buttonZiegelHinlegenClick)
        self.buttonMarkeSetzen.place(x=205, y=86, width=90, height=27)
        # Button Ziegel aufheben
        self.buttonMarkeLoeschen = Button(master=self.rahmenSteuerung, text="Ziegel aufheben", command=self.buttonZiegelAufhebenClick)
        self.buttonMarkeLoeschen.place(x=205, y=126, width=90, height=27)
        # Button initialisieren
        self.buttonInitialisieren = Button(master=self.rahmenSteuerung, text="initialisieren", command=self.buttonInitialisierenClick)
        self.buttonInitialisieren.place(x=105, y=126, width=90, height=27)

        # MyKaQuelltext
        # Rahmen
        self.rahmenMyKa = Frame(master=self.fenster, background=gruen)
        self.rahmenMyKa.place(x=5, y=5, width=300, height=250)
        # Texteditor für das Programm
        self.scrollbarMyKa = Scrollbar(master=self.rahmenMyKa)
        self.scrollbarMyKa.place(x=280, y=8, width=10, height=197)
        self.textMyKa = Text(master=self.rahmenMyKa, width=32, height=12, wrap=WORD, yscrollcommand=self.scrollbarMyKa.set)
        self.scrollbarMyKa["command"] = self.textMyKa.yview
        self.textMyKa.place(x=8, y=8)
        # Programm laden
        self.buttonProgrammLaden = Button(master=self.rahmenMyKa, text="laden", command=self.Button_ProgrammLaden_Click)
        self.buttonProgrammLaden.place(x=8, y=215, width=90, height=27)
        # Programm speichern
        self.buttonProgrammSpeichern = Button(master=self.rahmenMyKa, text="speichern", command=self.Button_ProgrammSpeichern_Click)
        self.buttonProgrammSpeichern.place(x=106, y=215, width=90, height=27)
        # Programm übersetzen
        self.buttonProgrammKompilieren = Button(master=self.rahmenMyKa, text="scannen / parsen", command=self.Button_MyKa_Uebersetzen_Click)
        self.buttonProgrammKompilieren.place(x=204, y=215, width=90, height=27)

        # MyKaList
        # Rahmen
        self.rahmenMyKaList = Frame(master=self.fenster, background=gelb)
        self.rahmenMyKaList.place(x=5, y=265, width=300, height=350)
        # Text-Fenster für MyKaList
        self.scrollbarMyKaList = Scrollbar(master=self.rahmenMyKaList)
        self.scrollbarMyKaList.place(x=280, y=8, width=10, height=294)
        self.textMyKaList = Text(master=self.rahmenMyKaList, width=32, height=18, wrap=WORD, yscrollcommand=self.scrollbarMyKaList.set)
        self.scrollbarMyKaList["command"] = self.textMyKaList.yview
        self.textMyKaList.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonMyKaListAnweisungAusfuehren = Button(master=self.rahmenMyKaList, text="Anw. ausführen", command=self.Button_MyKaList_AnweisungAusfuehren_Click)
        self.buttonMyKaListAnweisungAusfuehren.place(x=8, y=315, width=90, height=27)
        # Button Programm ausführen
        self.buttonMyKaListProgrammAusfuehren = Button(master=self.rahmenMyKaList, text="Prog. ausführen", command=self.Button_MyKaList_ProgrammAusfuehren_Click)
        self.buttonMyKaListProgrammAusfuehren.place(x=106, y=315, width=90, height=27)
        # Button Programm übersetzen
        self.buttonProgrammUebersetzen = Button(master=self.rahmenMyKaList, text="Code erzeugen", command=self.Button_MyKaList_Uebersetzen_Click)
        self.buttonProgrammUebersetzen.place(x=204, y=315, width=90, height=27)

        # MyKaGoto
        # Rahmen
        self.rahmenMyKaGoto = Frame(master=self.fenster, background=rot)
        self.rahmenMyKaGoto.place(x=315, y=265, width=300, height=350)
        # Text-Fenster für MyKaList
        self.scrollbarMyKaGoto = Scrollbar(master=self.rahmenMyKaGoto)
        self.scrollbarMyKaGoto.place(x=280, y=8, width=10, height=294)
        self.textMyKaGoto = Text(master=self.rahmenMyKaGoto, width=32, height=18, wrap=WORD, yscrollcommand=self.scrollbarMyKaGoto.set)
        self.scrollbarMyKaGoto["command"] = self.textMyKaGoto.yview
        self.textMyKaGoto.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonMyKaGotoAnweisungAusfuehren = Button(master=self.rahmenMyKaGoto, text="Anweisung ausführen", command=self.Button_MyKaGoto_AnweisungAusfuehren_Click)
        self.buttonMyKaGotoAnweisungAusfuehren.place(x=8, y=315, width=120, height=27)
        # Button Programm ausführen
        self.buttonMyKaGotoProgrammAusfuehren = Button(master=self.rahmenMyKaGoto, text="Programm ausführen", command=self.Button_MyKaGoto_ProgrammAusfuehren_Click)
        self.buttonMyKaGotoProgrammAusfuehren.place(x=172, y=315, width=120, height=27)
        # Programmcode initialisieren
        #self.aktualisiereProgrammCode()

    def erzeugeWeltGrafik(self):
        breiteCanvas = int(self.canvas.cget("width"))-4
        groesseX = self.welt.getFelderX()
        groesseY = self.welt.getFelderY()
        breiteZelle = breiteCanvas / groesseX
        # erzeuge die Rechteck-Objekte für die Felder
        # erzeuge die Text-Objekte für die Anzahl der Ziegel
        m_Rechteck = []
        m_Text = []
        for j in range(groesseY):
            l_Rechteck = []
            l_Text = []
            for i in range(groesseX):
                # betimme die Koordinaten der Ecken des Feldes
                x1 = i*breiteZelle+3
                y1 = j*breiteZelle+3
                x2 = (i+1)*breiteZelle+3
                y2 = (j+1)*breiteZelle + 3
                # bestimme die Farbe des Feldes
                if self.welt.getZiegel(i, j) > 0:
                    farbe = "red"
                    if self.welt.getMarke(i, j):
                        farbe = "yellow"
                else:
                    if self.welt.getMarke(i, j):
                        farbe = "yellow"
                    else:
                        farbe = "white"
                # erzeuge das Rechteck-Objekt zum Feld
                l_Rechteck = l_Rechteck + [self.canvas.create_rectangle(x1, y1, x2, y2, fill=farbe)]
                # erzeuge das Text-Objekt zum Feld
                if self.welt.getZiegel(i, j) > 0:
                    l_Text = l_Text + [self.canvas.create_text(x1 + breiteZelle/2, y1 + breiteZelle/2, text=str(welt.getZiegel(i, j)))]
                else:
                    l_Text = l_Text + [self.canvas.create_text(x1 + breiteZelle/2, y1 + breiteZelle/2, text='')]
            m_Rechteck = m_Rechteck + [l_Rechteck]
            m_Text = m_Text + [l_Text]
        # verwalte die Rechteck- und Text-Objekte mit den folgenden Attributen
        self.id_felder = m_Rechteck
        self.id_texte = m_Text

    def erzeugeRoboterGrafik(self):
        breiteCanvas = int(self.canvas.cget("width"))-4
        groesseX = self.welt.getFelderX()
        groesseY = self.welt.getFelderY()
        breiteZelle = breiteCanvas / groesseX
        # bestimme die Eckpunkte des Roboterfeldes
        x1 = self.rob.getX()*breiteZelle + 3
        y1 = self.rob.getY()*breiteZelle + 3
        x2 = x1 + breiteZelle
        y2 = y1 + breiteZelle
        # bestimme die Eckpunkte des Dreiecks
        r = self.rob.getR()
        if r == 'O':
            (a_x, a_y) = (x1, y1)
            (b_x, b_y) = (x2, (y1+y2)/2)
            (c_x, c_y) = (x1, y2)
        elif r == 'S':
            (a_x, a_y) = (x1, y1)
            (b_x, b_y) = (x2, y1)
            (c_x, c_y) = ((x1+x2)/2, y2)
        elif r == 'W':
            (a_x, a_y) = (x2, y1)
            (b_x, b_y) = (x2, y2)
            (c_x, c_y) = (x1, (y1+y2)/2)
        elif r == 'N':
            (a_x, a_y) = (x2, y2)
            (b_x, b_y) = (x1, y2)
            (c_x, c_y) = ((x1+x2)/2, y1)
        farbe = "blue"
        # erzeuge ein Dreieck zum Roboter
        self.id_roboter = self.canvas.create_polygon(a_x, a_y, b_x, b_y, c_x, c_y, a_x, a_y ,fill=farbe)
        try:
            self.id_robotertext = self.canvas.create_text(x1 + breiteZelle/2, y1 + breiteZelle/2, fill="white", text=str(self.rob.getRucksack()))
        except:
            pass

    def aktualisiereWeltGrafik(self):
        groesseX = self.welt.getFelderX()
        groesseY = self.welt.getFelderY()
        for j in range(groesseY):
            for i in range(groesseX):
                # bestimme die Farbe des Feldes
                if self.welt.getZiegel(i, j) > 0:
                    farbe = "red"
                    if self.welt.getMarke(i, j):
                        farbe = "yellow"
                else:
                    if self.welt.getMarke(i, j):
                        farbe = "yellow"
                    else:
                        farbe = "white"
                # aktualisiere die Farbe und den Text des Rechtecks zum Feld
                self.canvas.itemconfigure(self.id_felder[j][i], fill=farbe)
                if self.welt.getZiegel(i, j) > 0:
                    self.canvas.itemconfigure(self.id_texte[j][i], text=str(self.welt.getZiegel(i, j)))
                else:
                    self.canvas.itemconfigure(self.id_texte[j][i], text='')

    def aktualisiereRoboterGrafik(self):
        # lösche das aktuelle Roboter-Dreieck
        self.canvas.delete(self.id_roboter)
        #self.canvas.delete(self.id_robotertext)
        breiteCanvas = int(self.canvas.cget("width"))-4
        groesseX = self.welt.getFelderX()
        groesseY = self.welt.getFelderY()
        breiteZelle = breiteCanvas / groesseX
        # bestimme die Eckpunkte des Roboterfeldes
        x1 = self.rob.getX()*breiteZelle + 3
        y1 = self.rob.getY()*breiteZelle + 3
        x2 = x1 + breiteZelle
        y2 = y1 + breiteZelle
        # bestimme die Eckpunkte des Dreiecks
        r = self.rob.getR()
        if r == 'O':
            (a_x, a_y) = (x1, y1)
            (b_x, b_y) = (x2, (y1+y2)/2)
            (c_x, c_y) = (x1, y2)
        elif r == 'S':
            (a_x, a_y) = (x1, y1)
            (b_x, b_y) = (x2, y1)
            (c_x, c_y) = ((x1+x2)/2, y2)
        elif r == 'W':
            (a_x, a_y) = (x2, y1)
            (b_x, b_y) = (x2, y2)
            (c_x, c_y) = (x1, (y1+y2)/2)
        elif r == 'N':
            (a_x, a_y) = (x2, y2)
            (b_x, b_y) = (x1, y2)
            (c_x, c_y) = ((x1+x2)/2, y1)
        farbe = "blue"
        # erzeuge ein neues Dreieck
        self.id_roboter = self.canvas.create_polygon(a_x, a_y, b_x, b_y, c_x, c_y, a_x, a_y ,fill=farbe)
        try:
            self.id_robotertext = self.canvas.create_text(x1 + breiteZelle/2, y1 + breiteZelle/2, fill="white", text=str(self.rob.getRucksack()))
        except:
            pass

    def aktualisiereMyKaListCode(self):
        self.textMyKaList.delete('1.0', END)
        p = self.interpreterMyKaList.getProgramm()
        if p != None:
            for a in p:
                self.textMyKaList.insert(END, str(a) + '\n' + '\n')

    def canvasInitialisieren(self, event):
        self.rob.setZustand(0, 0, 'S')
        self.welt.initFelder()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def buttonSchrittClick(self):
        self.rob.schritt()
        self.aktualisiereRoboterGrafik()

    def buttonLinksClick(self):
        self.rob.links()
        self.aktualisiereRoboterGrafik()

    def buttonRechtsClick(self):
        self.rob.rechts()
        self.aktualisiereRoboterGrafik()

    def buttonMarkeSetzenClick(self):
        self.rob.markeSetzen()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def buttonMarkeLoeschenClick(self):
        self.rob.markeLoeschen()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def buttonZiegelHinlegenClick(self):
        self.rob.ziegelHinlegen()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def buttonZiegelAufhebenClick(self):
        self.rob.ziegelAufheben()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def buttonInitialisierenClick(self):
        self.rob.setZustand(0, 0, 'S')
        self.welt.initFelder()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()

    def Button_MyKa_Uebersetzen_Click(self):
        quelltext = self.textMyKa.get('1.0', END)
        if len(quelltext) != 0:
            strukturbaum = self.parserMyKa.parse(quelltext, debug=0)
        else:
            strukturbaum = []
        self.interpreterMyKaList.setProgramm(strukturbaum)
        self.aktualisiereMyKaListCode()

    def Button_ProgrammLaden_Click(self):
        self.datei = tkinter.filedialog.askopenfile()
        self.textMyKa.delete(1.0, END)
        if self.datei:
            self.textMyKa.insert(1.0, self.datei.read())
            self.datei.close()

    def Button_ProgrammSpeichern_Click(self):
        self.datei = tkinter.filedialog.asksaveasfile()
        if self.datei:
            self.datei.write(self.textMyKa.get(1.0, END) )
            self.datei.close()

    def Button_MyKaList_AnweisungAusfuehren_Click(self):
        self.interpreterMyKaList.anweisungAusfuehren()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()
        self.aktualisiereMyKaListCode()

    def Button_MyKaList_ProgrammAusfuehren_Click(self):
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()
        self.aktualisiereMyKaListCode()
        if self.interpreterMyKaList.getProgramm() != []:
            self.interpreterMyKaList.anweisungAusfuehren()
            self.fenster.after(1000, self.Button_MyKaList_ProgrammAusfuehren_Click)

    def aktualisiereMyKaGotoProgrammCode(self):
        self.textMyKaGoto.delete('1.0', END)
        p = self.interpreterMyKaGoto.getProgramm()
        pc = self.interpreterMyKaGoto.getPC()
        for i in range(len(p)):
            if i != pc:
                self.textMyKaGoto.insert(END, "  " + str(p[i]) + '\n')
            else:
                self.textMyKaGoto.insert(END, "> " + str(p[i]) + '\n')

    def Button_MyKaList_Uebersetzen_Click(self):
        myKaListProgramm = self.interpreterMyKaList.getProgramm()
        self.compilerMyKaList.setQuellcode(myKaListProgramm)
        myKaGotoProgramm = self.compilerMyKaList.uebersetzen()
        self.interpreterMyKaGoto.initProgramm(myKaGotoProgramm)
        self.aktualisiereMyKaGotoProgrammCode()

    def Button_MyKaGoto_AnweisungAusfuehren_Click(self):
        self.interpreterMyKaGoto.anweisungAusfuehren()
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()
        self.aktualisiereMyKaGotoProgrammCode()

    def Button_MyKaGoto_ProgrammAusfuehren_Click(self):
        self.aktualisiereWeltGrafik()
        self.aktualisiereRoboterGrafik()
        self.aktualisiereMyKaGotoProgrammCode()
        if self.interpreterMyKaGoto.getPC() < len(self.interpreterMyKaGoto.getProgramm()):
            self.interpreterMyKaGoto.anweisungAusfuehren()
            self.fenster.after(1000, self.Button_MyKaGoto_ProgrammAusfuehren_Click)

    def druckGotoCode(self, anweisung):
        if anweisung[0] != None:
            druck = 'label ' + anweisung[0]
        else:
            if anweisung[1][0] in ["schritt",
                              "links",
                              "rechts",
                              "ziegelHinlegen",
                              "ziegelAufheben",
                              "markeSetzen",
                              "markeLoeschen",
                              "pass"]:
                druck = anweisung[1][0]
            elif anweisung[1][0] == 'if':
                druck = 'if ' + anweisung[1][1][0] + ': ' + str(anweisung[1][2][0]) + ' ' + str(anweisung[1][2][1]) +  '\n' + 'else: ' + str(anweisung[1][3][0]) + ' ' + str(anweisung[1][3][1])
            elif anweisung[1][0] == 'goto':
                druck = 'goto ' + str(anweisung[1][1])
            elif anweisung[1][0] == 'noop':
                druck = 'noop'
        return druck

    def aktualisiereMyKaGotoProgrammCode(self):
        self.textMyKaGoto.delete('1.0', END)
        p = self.interpreterMyKaGoto.getProgramm()
        pc = self.interpreterMyKaGoto.getPC()
        for i in range(len(p)):
            if i != pc:
                self.textMyKaGoto.insert(END, "" + self.druckGotoCode(p[i]) + '\n')
            else:
                self.textMyKaGoto.insert(END, ">" + self.druckGotoCode(p[i]) + '\n')

#-------------------------------------------------------------

import ply.lex as lex
import ply.yacc as yacc
from syntaxMyKa import *
from roboterwelt import *
from interpreterMyKaList import *
from compilerMyKa import *
from interpreterMyKaGoto import *
from compilerMyKaList import *
# Erzeugung des Scanners
scannerMyKa = lex.lex(debug=0)
# Erzeugung des Parsers
parserMyKa = yacc.yacc(debug=False)
# Erzeugung der Roboterwelt
welt = Welt(5, 5)
rob = Roboter()
rob.setWelt(welt)
# Erzeugung der Interpreter
interpreterMyKaList = InterpreterMyKaList(rob)
interpreterMyKaGoto = InterpreterMyKaGoto(rob)
# Erzeugung der Übersetzer
compilerMyKa = CompilerMyKa()
compilerMyKaList = CompilerMyKaList()
# Erzeugung der GUI
roboterGUI = RoboterGUI(rob, welt, parserMyKa, interpreterMyKaList, compilerMyKaList, interpreterMyKaGoto)
roboterGUI.fenster.mainloop()
