# -*- coding: iso-8859-1 -*-

class Interpreter(object):
    def __init__(self, r):
        self.programm = None
        self.roboter = r

    def setProgramm(self, p):
        self.programm = p

    def getProgramm(self):
        return self.programm

    def anweisungAusfuehren(self):
        if self.programm != []:
            anweisung = self.programm[0]
            bezeichner = anweisung[0]
            if bezeichner in ["s", "l", "r", "zh", "za", "ms", "ml"]:
                self.verarbeiteAnweisung(bezeichner)
                self.programm = self.programm[1:]
            elif bezeichner == "wh":
                bedingung = anweisung[1]
                bezeichner_bedingung = bedingung[0]
                if self.verarbeiteBedingung(bezeichner_bedingung):
                    self.programm = anweisung[2] + self.programm
                else:
                    self.programm = self.programm[3:]

    def verarbeiteAnweisung(self, bezeichner):
        if bezeichner == "s":
            self.roboter.schritt()
        elif bezeichner == "l":
            self.roboter.links()
        elif bezeichner == "r":
            self.roboter.rechts()
        elif bezeichner == "ms":
            self.roboter.markeSetzen()
        elif bezeichner == "ml":
            self.roboter.markeLoeschen()
        elif bezeichner == "zh":
            self.roboter.ziegelHinlegen()
        elif bezeichner == "za":
            self.roboter.ziegelAufheben()

    def verarbeiteBedingung(self, bezeichner):
        if bezeichner == "vz":
            return self.roboter.vorZiegel()
        elif bezeichner == "vz":
            return self.roboter.nichtVorZiegel()
        elif bezeichner == "vw":
            return self.roboter.vorWand()
        elif bezeichner == "nw":
            return self.roboter.nichtVorWand()
