class InterpreterMyKaGoto(object):
    def __init__(self, rob):
        self.programm = None
        self.pc = 0
        self.roboter = rob


    def initProgramm(self, p):
        self.programm = p
        self.pc = 0

    def getProgramm(self):
        return self.programm

    def getPC(self):
        return self.pc

    def anweisungAusfuehren(self):
        if self.pc < len(self.programm):
            zeile = self.programm[self.pc]
            label = zeile[0]
            if label != None:
                self.pc = self.pc + 1
            else:
                anweisung = zeile[1]
                if anweisung[0] in ["schritt",
                              "links",
                              "rechts",
                              "ziegelHinlegen",
                              "ziegelAufheben",
                              "markeSetzen",
                              "markeLoeschen",
                              "pass"]:
                    self.verarbeiteAnweisung(anweisung[0])
                    self.pc = self.pc + 1
                elif anweisung[0] == "if":
                    if self.verarbeiteBedingung(anweisung[1][0]):
                        self.verarbeiteGoto(anweisung[2])
                    else:
                        self.verarbeiteGoto(anweisung[3])
                elif anweisung[0] == "goto":
                    self.verarbeiteGoto(anweisung)
                elif anweisung[0] == "noop":
                    self.pc = self.pc + 1
                    
    def verarbeiteAnweisung(self, bezeichner):
        if bezeichner == "schritt":
            self.roboter.schritt()
        elif bezeichner == "links":
            self.roboter.links()
        elif bezeichner == "rechts":
            self.roboter.rechts()
        elif bezeichner == "markeSetzen":
            self.roboter.markeSetzen()
        elif bezeichner == "markeLoeschen":
            self.roboter.markeLoeschen()
        elif bezeichner == "ziegelHinlegen":
            self.roboter.ziegelHinlegen()
        elif bezeichner == "ziegelAufheben":
            self.roboter.ziegelAufheben()
        elif bezeichner == "pass":
            self.roboter.pause()

    def verarbeiteBedingung(self, bezeichner):
        if bezeichner == "vorZiegel":
            return self.roboter.vorZiegel()
        elif bezeichner == "nichtVorZiegel":
            return self.roboter.nichtVorZiegel()
        elif bezeichner == "vorWand":
            return self.roboter.vorWand()
        elif bezeichner == "nichtVorWand":
            return self.roboter.nichtVorWand()
        elif bezeichner == "aufMarke":
            return self.roboter.aufMarke()
        elif bezeichner == "nichtAufMarke":
            return self.roboter.nichtAufMarke()

    def verarbeiteGoto(self, anweisung):
        label = anweisung[1]
        self.pc = 0
        while self.programm[self.pc][0] != label:
            self.pc = self.pc + 1
            
