# Namen der Token
tokens = ['ELANW', 'BED', 'DP', 'WH', 'WH_ENDE', 'IF', 'IF_ENDE', 'ELSE', 'PASS']

# Beschreibung der Token
t_ELANW    = r'schritt|links|rechts|ziegelHinlegen|ziegelAufheben|markeSetzen|markeLoeschen'
t_BED      = r'vorZiegel|nichtVorZiegel|vorWand|nichtVorWand|aufMarke|nichtAufMarke'
t_DP       = r':'
t_WH       = r'while'
t_WH_ENDE  = r'\#while'
t_IF       = r'if'
t_IF_ENDE  = r'\#if'
t_ELSE     = r'else'
t_PASS     = r'pass'

# Ignorierte Zeichen
t_ignore = " \t"

def t_newline(t):
    r'\n+'
    t.lexer.lineno = t.lexer.lineno + t.value.count("\n")

def t_error(t):
    print("Illegal character '%s'" % t.value[0])
    t.lexer.skip(1)

# Produktionen

def p_anweisungsfolge_anweisung_anweisungsfolge(p):
    'anweisungsfolge : anweisung anweisungsfolge'
    p[0] = [p[1]] + p[2]

def p_anweisungsfolge_anweisung(p):
    'anweisungsfolge : anweisung'
    p[0] = [p[1]]

def p_anweisung_elementar(p):
    'anweisung : ELANW'
    p[0] = [p[1]]

def p_anweisung_pass(p):
    'anweisung : PASS'
    p[0] = [p[1]]

def p_anweisung_wh(p):
    'anweisung : WH bedingung DP anweisungsfolge WH_ENDE'
    p[0] = [p[1]] + [p[2]] + [p[4]]

def p_anweisung_if(p):
    'anweisung : IF bedingung DP anweisungsfolge ELSE DP anweisungsfolge IF_ENDE'
    p[0] = [p[1]] + [p[2]] + [p[4]] + [p[7]]

def p_bedingung(p):
    'bedingung : BED'
    p[0] = [p[1]]

# Fehlermeldung
def p_error(p):
    print("Syntaxfehler!")



