class AssemblerGoto(object):
    def __init__(self, v):
        self.programm = None
        self.variablenzustand = v
        self.assemblerprogramm = []


    def initProgramm(self, p):
        self.programm = p

    def getProgramm(self):
        return self.programm

    def getAssemblerprogramm(self):
        return self.assemblerprogramm

    def erzeugeAssemblerprogramm(self):
        # 1. Durchlauf: Assemblerbefehle
        for zeile in self.programm:
            label = zeile[0]
            if label != None:
                self.assemblerprogramm = self.assemblerprogramm + [[zeile[0], "NOP", None]]
            else:
                anweisung = zeile[1]
                if anweisung[0] == "=":
                    variable = anweisung[1][1]
                    term = anweisung[2]
                    if len(term) == 1:
                        if term[0][0] == "NAT":
                            self.assemblerprogramm = self.assemblerprogramm + [[None, "LCA", int(term[0][1])], [None, "STA", variable]]
                        elif term[0][0] == "VAR":
                            self.assemblerprogramm = self.assemblerprogramm + [[None, "LDA", term[0][1]], [None, "STA", variable]]
                    else:
                        op = term[0]
                        if op == "+":
                            if term[2][0] == "NAT":
                                self.assemblerprogramm = self.assemblerprogramm + [[None, "LDA", term[1][1]], [None, "ADC", int(term[2][1])], [None, "STA", variable]]
                            elif term[2][0] == "VAR":
                                self.assemblerprogramm = self.assemblerprogramm + [[None, "LDA", term[1][1]], [None, "ADA", term[2][1]], [None, "STA", variable]]
                        elif op == "-":
                            if term[2][0] == "NAT":
                                self.assemblerprogramm = self.assemblerprogramm + [[None, "LDA", term[1][1]], [None, "SBC", int(term[2][1])], [None, "STA", variable]]
                            elif term[2][0] == "VAR":
                                self.assemblerprogramm = self.assemblerprogramm + [[None, "LDA", term[1][1]], [None, "SBA", term[2][1]], [None, "STA", variable]]
                elif anweisung[0] == "if":
                    bedingung = anweisung[1]
                    if_anweisung = anweisung[2]
                    else_anweisung = anweisung[3]
                    if bedingung[0] in ["==", "!=", ">", "<"]:
                        self.assemblerprogramm = self.assemblerprogramm + [[None, "TNE", bedingung[1][1]], [None, "JMP", if_anweisung[1]], [None, "JMP", else_anweisung[1]]]                    
                elif anweisung[0] == "goto":
                    self.assemblerprogramm = self.assemblerprogramm + [[None, "JMP", anweisung[1]]]
                elif anweisung[0] == "stop":
                    self.assemblerprogramm = self.assemblerprogramm + [[None, "HLT", None]]
        # Ausgabe
        """print()
        for zeile in self.assemblerprogramm:
            print(zeile)"""
        # 2. Durchlauf: NOP entfernen
        n = len(self.assemblerprogramm)
        i = 0
        while i < n:
            if self.assemblerprogramm[i][0] != None and i+1 < n:
                self.assemblerprogramm[i+1][0] = self.assemblerprogramm[i][0]
                i = i+1
            i = i+1
        neues_assemblerprogramm = []
        for zeile in self.assemblerprogramm:
            if zeile[1] != "NOP":
                neues_assemblerprogramm = neues_assemblerprogramm + [zeile]
        self.assemblerprogramm = neues_assemblerprogramm
        # Ausgabe
        """print()
        for zeile in self.assemblerprogramm:
            print(zeile)"""
        # 3. Durchlauf Zeilennummerierung
        n = len(self.assemblerprogramm)
        for i in range(n):
            if self.assemblerprogramm[i][0] != None:
                label = self.assemblerprogramm[i][0]
                self.assemblerprogramm[i][0] = i
                for j in range(n):
                    if self.assemblerprogramm[j][2] == label:
                        self.assemblerprogramm[j][2] = i
            else:
                self.assemblerprogramm[i][0] = i
        # Ausgabe
        """print()
        for zeile in self.assemblerprogramm:
            print(zeile)"""
        # 4. Variablen ersetzen
        k = n
        variablen_register = {}
        for zeile in self.assemblerprogramm:
            if type(zeile[2]) == str:
                v = zeile[2]
                if v not in variablen_register:
                    variablen_register[v] = k
                    k = k + 1
        n = len(self.assemblerprogramm)
        for i in range(n):
            if type(self.assemblerprogramm[i][2]) == str:
                v = self.assemblerprogramm[i][2]
                self.assemblerprogramm[i][2] = variablen_register[v]
        # Ausgabe
        """print()
        for zeile in self.assemblerprogramm:
            print(zeile)"""
           
                


    def verarbeiteZuweisung(self, anweisung):
        variable = anweisung[1][1]
        term = anweisung[2]
        self.variablenzustand.setVariable(variable, self.wertTerm(term))

    def verarbeiteGoto(self, anweisung):
        label = anweisung[1]
        self.pc = 0
        while self.programm[self.pc][0] != label:
            self.pc = self.pc + 1
            
    def wertOperand(self, operand):
        if operand[0] == "NAT":
            return int(operand[1])
        elif operand[0] == "VAR":
            return self.variablenzustand.getVariable(operand[1])

    def wertTerm(self, term):
        if len(term) == 1:
            return self.wertOperand(term[0])
        else:
            wertOperand1 = self.wertOperand(term[1])
            wertOperand2 = self.wertOperand(term[2])
            op = term[0]
            if op == "+":
                return wertOperand1 + wertOperand2
            elif op == "-":
                return wertOperand1 - wertOperand2
                


    def verarbeiteBedingung(self, bedingung):
        wertOperand1 = self.wertOperand(bedingung[1])
        wertOperand2 = self.wertOperand(bedingung[2])
        rel = bedingung[0]
        if rel == "!=":
            return (wertOperand1 != wertOperand2)
        elif rel == ">":
            return (wertOperand1 > wertOperand2)
