from tkinter import *
import tkinter.filedialog

class WhileGUI:

    def __init__(self, variablenzustand, scannerparserWhile, interpreterWhileList, compilerWhileList, interpreterGoto, assemblerGoto):
        # Referenzattribute zum Datenmodell
        self.variablenzustand = variablenzustand
        self.scannerparserWhile = scannerparserWhile
        self.interpreterWhileList = interpreterWhileList
        self.compilerWhileList = compilerWhileList
        self.interpreterGoto = interpreterGoto
        self.assemblerGoto = assemblerGoto


        # Erzeugung des Fensters
        self.fenster = Tk()
        self.fenster.title("MyWhile")
        self.fenster.geometry('620x620')
        # Farben
        blau = "#BDE2F3"
        rot = "#FFCFC9"
        gelb = "#FBD975"
        gruen = "#D5E88F"

        # WhileQuelltext
        self.rahmenWhile = Frame(master=self.fenster, background=gruen)
        self.rahmenWhile.place(x=5, y=5, width=300, height=250)
        # Texteditor für das Programm
        self.scrollbarWhile = Scrollbar(master=self.rahmenWhile)
        self.scrollbarWhile.place(x=280, y=8, width=10, height=197)
        self.textWhile = Text(master=self.rahmenWhile, width=32, height=12, wrap=WORD, yscrollcommand=self.scrollbarWhile.set)
        self.scrollbarWhile["command"] = self.textWhile.yview
        self.textWhile.place(x=8, y=8)
        # Programm laden
        self.buttonProgrammLaden = Button(master=self.rahmenWhile, text="laden", command=self.Button_ProgrammLaden_Click)
        self.buttonProgrammLaden.place(x=8, y=215, width=90, height=27)
        # Programm speichern
        self.buttonProgrammSpeichern = Button(master=self.rahmenWhile, text="speichern", command=self.Button_ProgrammSpeichern_Click)
        self.buttonProgrammSpeichern.place(x=106, y=215, width=90, height=27)
        # Programm übersetzen
        self.buttonProgrammKompilieren = Button(master=self.rahmenWhile, text="scannen / parsen", command=self.Button_While_Uebersetzen_Click)
        self.buttonProgrammKompilieren.place(x=204, y=215, width=90, height=27)

        # WhileList
        # Rahmen
        self.rahmenWhileList = Frame(master=self.fenster, background=gelb)
        self.rahmenWhileList.place(x=5, y=265, width=300, height=350)
        # Text-Fenster für WhileList
        self.scrollbarWhileList = Scrollbar(master=self.rahmenWhileList)
        self.scrollbarWhileList.place(x=280, y=8, width=10, height=294)
        self.textWhileList = Text(master=self.rahmenWhileList, width=32, height=18, wrap=WORD, yscrollcommand=self.scrollbarWhileList.set)
        self.scrollbarWhileList["command"] = self.textWhileList.yview
        self.textWhileList.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonWhileListAnweisungAusfuehren = Button(master=self.rahmenWhileList, text="Anw. ausführen", command=self.Button_WhileList_AnweisungAusfuehren_Click)
        self.buttonWhileListAnweisungAusfuehren.place(x=8, y=315, width=90, height=27)
        # Button Programm ausführen
        self.buttonWhileListProgrammAusfuehren = Button(master=self.rahmenWhileList, text="Prog. ausführen", command=self.Button_WhileList_ProgrammAusfuehren_Click)
        self.buttonWhileListProgrammAusfuehren.place(x=106, y=315, width=90, height=27)
        # Button Programm übersetzen
        self.buttonProgrammUebersetzen = Button(master=self.rahmenWhileList, text="Code erzeugen", command=self.Button_WhileList_Uebersetzen_Click)
        self.buttonProgrammUebersetzen.place(x=204, y=315, width=90, height=27)

        # WhileGoto
        # Rahmen
        self.rahmenWhileGoto = Frame(master=self.fenster, background=rot)
        self.rahmenWhileGoto.place(x=315, y=265, width=300, height=350)
        # Text-Fenster für WhileList
        self.scrollbarWhileGoto = Scrollbar(master=self.rahmenWhileGoto)
        self.scrollbarWhileGoto.place(x=280, y=8, width=10, height=294)
        self.textWhileGoto = Text(master=self.rahmenWhileGoto, width=32, height=18, wrap=WORD, yscrollcommand=self.scrollbarWhileGoto.set)
        self.scrollbarWhileGoto["command"] = self.textWhileGoto.yview
        self.textWhileGoto.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonWhileGotoAnweisungAusfuehren = Button(master=self.rahmenWhileGoto, text="Anw. ausführen", command=self.Button_WhileGoto_AnweisungAusfuehren_Click)
        self.buttonWhileGotoAnweisungAusfuehren.place(x=8, y=315, width=90, height=27)
        # Button Programm ausführen
        self.buttonWhileGotoProgrammAusfuehren = Button(master=self.rahmenWhileGoto, text="Prog. ausführen", command=self.Button_WhileGoto_ProgrammAusfuehren_Click)
        self.buttonWhileGotoProgrammAusfuehren.place(x=106, y=315, width=90, height=27)
        # Button Programm ausführen
        self.buttonAssemblerProgrammErzeugen = Button(master=self.rahmenWhileGoto, text="Goto <-> Assem.", command=self.Button_WhileGoto_AssemblerprogrammErzeugen_Click)
        self.buttonAssemblerProgrammErzeugen.place(x=204, y=315, width=90, height=27)
        self.goto_assembler = "goto"

        # Variablenzustand
        # Rahmen
        self.variablenZustand = Frame(master=self.fenster, background=blau)
        self.variablenZustand.place(x=315, y=5, width=300, height=250)
        # Text-Fenster für Variablenzustand
        self.scrollbarVariablenZustand = Scrollbar(master=self.variablenZustand)
        self.scrollbarVariablenZustand.place(x=280, y=8, width=10, height=197)
        self.textVariablenZustand = Text(master=self.variablenZustand, width=32, height=12, wrap=WORD, yscrollcommand=self.scrollbarVariablenZustand.set)
        self.scrollbarVariablenZustand["command"] = self.textVariablenZustand.yview
        self.textVariablenZustand.place(x=8, y=8)

        # Button initialisieren
        self.buttonInitialisieren = Button(master=self.variablenZustand, text="initialisieren", command=self.buttonInitialisierenClick)
        self.buttonInitialisieren.place(x=106, y=215, width=90, height=27)

    def aktualisiereVariablenzustand(self):
        self.textVariablenZustand.delete('1.0', END)
        p = self.variablenzustand.variablen
        if p != None:
            for v in p.items():
                self.textVariablenZustand.insert(END, str(v[0]) + ' -> ' + str(v[1]) + '\n')

    def aktualisiereWhileListCode(self):
        self.textWhileList.delete('1.0', END)
        p = self.interpreterWhileList.getProgramm()
        if p != None:
            for a in p:
                self.textWhileList.insert(END, str(a) + '\n' + '\n')

    def buttonInitialisierenClick(self):
        self.variablenzustand.initVariablen()
        self.aktualisiereVariablenzustand()

    def Button_While_Uebersetzen_Click(self):
        quelltext = self.textWhile.get('1.0', END)
        if len(quelltext) != 0:
            strukturbaum = self.scannerparserWhile.parse(quelltext, debug=0)
        else:
            strukturbaum = []
        self.interpreterWhileList.setProgramm(strukturbaum)
        self.aktualisiereWhileListCode()

    def Button_ProgrammLaden_Click(self):
        self.datei = tkinter.filedialog.askopenfile()
        self.textWhile.delete(1.0, END)
        if self.datei:
            self.textWhile.insert(1.0, self.datei.read())
            self.datei.close()

    def Button_ProgrammSpeichern_Click(self):
        self.datei = tkinter.filedialog.asksaveasfile()
        if self.datei:
            self.datei.write(self.textWhile.get(1.0, END) )
            self.datei.close()

    def Button_WhileList_AnweisungAusfuehren_Click(self):
        self.interpreterWhileList.anweisungAusfuehren()
        self.aktualisiereWhileListCode()
        self.aktualisiereVariablenzustand()


    def Button_WhileList_ProgrammAusfuehren_Click(self):
        self.aktualisiereVariablenzustand()
        self.aktualisiereWhileListCode()
        if self.interpreterWhileList.getProgramm() != []:
            self.interpreterWhileList.anweisungAusfuehren()
            self.fenster.after(1000, self.Button_WhileList_ProgrammAusfuehren_Click)

    def druckGotoCode(self, anweisung):
        if anweisung[0] != None:
            druck = 'label ' + anweisung[0]
        else:
            if anweisung[1][0] == "=":
                if len(anweisung[1][2]) == 1:
                    druck = str(anweisung[1][1][1]) + str(anweisung[1][0]) + str(anweisung[1][2][0][1])
                else:
                    druck = str(anweisung[1][1][1]) + str(anweisung[1][0]) + \
                                    str(anweisung[1][2][1][1]) + str(anweisung[1][2][0]) + str(anweisung[1][2][2][1])
            elif anweisung[1][0] == 'if':
                druck = 'if ' + str(anweisung[1][1][1][1]) + str(anweisung[1][1][0]) + str(anweisung[1][1][2][1]) + ':' + '\n' + \
                        '    ' + str(anweisung[1][2][0]) + ' ' + str(anweisung[1][2][1]) + '\n' + \
                        'else:' + '\n' + \
                        '    ' + str(anweisung[1][3][0]) + ' ' + str(anweisung[1][3][1]) 
            elif anweisung[1][0] == 'goto':
                druck = 'goto ' + str(anweisung[1][1])
            elif anweisung[1][0] == 'noop':
                druck = 'noop'
        return druck

    def aktualisiereWhileGotoProgrammCode(self):
        self.textWhileGoto.delete('1.0', END)
        p = self.interpreterGoto.getProgramm()
        pc = self.interpreterGoto.getPC()
        for i in range(len(p)):
            if i != pc:
                self.textWhileGoto.insert(END, "" + self.druckGotoCode(p[i]) + '\n')
            else:
                self.textWhileGoto.insert(END, ">" + self.druckGotoCode(p[i]) + '\n')

    def Button_WhileList_Uebersetzen_Click(self):
        self.compilerWhileList.setQuellcode(self.interpreterWhileList.getProgramm())
        gotoCode = self.compilerWhileList.uebersetzen()
        self.interpreterGoto.initProgramm(gotoCode)
        self.variablenzustand.initVariablen()
        self.aktualisiereVariablenzustand()
        self.aktualisiereWhileGotoProgrammCode()
        

    def Button_WhileGoto_AnweisungAusfuehren_Click(self):
        self.interpreterGoto.anweisungAusfuehren()
        self.aktualisiereWhileGotoProgrammCode()
        self.aktualisiereVariablenzustand()

    def Button_WhileGoto_ProgrammAusfuehren_Click(self):
        while self.interpreterGoto.getPC() < len(self.interpreterGoto.getProgramm()):
            self.interpreterGoto.anweisungAusfuehren()
        self.aktualisiereWhileGotoProgrammCode()
        self.aktualisiereVariablenzustand()

    def Button_WhileGoto_AssemblerprogrammErzeugen_Click(self):
        if self.goto_assembler == "goto":
            gotoCode = self.compilerWhileList.uebersetzen()
            self.assemblerGoto.initProgramm(gotoCode)
            self.assemblerGoto.erzeugeAssemblerprogramm()
            self.textWhileGoto.delete('1.0', END)
            p = self.assemblerGoto.getAssemblerprogramm()
            for i in range(len(p)):
                self.textWhileGoto.insert(END, str(p[i]) + '\n')
            self.goto_assembler = "assembler"
        else:
            self.aktualisiereWhileGotoProgrammCode()
            self.goto_assembler = "goto"




#-------------------------------------------------------------

import ply.lex as lex
import ply.yacc as yacc
from syntaxWhile import *
# Erzeugung des Scanners
scannerWhile = lex.lex(debug=0)
# Erzeugung des Parsers
parserWhile = yacc.yacc(debug=False)




from interpreterWhileList import *
from interpreterGoto import *
from uebersetzerWhileList import *
from variablenzustand import *


from assemblerGoto import *


# Erzeugung des GUI-Objekts

variablenzustand = Variablenzustand()
interpreterWhileList = InterpreterWhileList(variablenzustand)
interpreterGoto = InterpreterGoto(variablenzustand)
uebersetzerWhileList = UebersetzerWhileList()

assemblerGoto = AssemblerGoto(variablenzustand)

whileGUI = WhileGUI(variablenzustand, parserWhile, interpreterWhileList, uebersetzerWhileList, interpreterGoto, assemblerGoto)
whileGUI.fenster.mainloop()
