class InterpreterGoto(object):
    def __init__(self, v):
        self.programm = None
        self.pc = 0
        self.variablenzustand = v

    def initProgramm(self, p):
        self.programm = p
        self.pc = 0

    def getProgramm(self):
        return self.programm

    def getPC(self):
        return self.pc

    def anweisungAusfuehren(self):
        if self.pc < len(self.programm):
            zeile = self.programm[self.pc]
            label = zeile[0]
            if label != None:
                self.pc = self.pc + 1
            else:
                anweisung = zeile[1]
                if anweisung[0] == "=":
                    self.verarbeiteZuweisung(anweisung)
                    self.pc = self.pc + 1
                elif anweisung[0] == "if":
                    if self.verarbeiteBedingung(anweisung[1]):
                        self.verarbeiteGoto(anweisung[2])
                    else:
                        self.verarbeiteGoto(anweisung[3])
                elif anweisung[0] == "goto":
                    self.verarbeiteGoto(anweisung)
                elif anweisung[0] == "noop":
                    self.pc = self.pc + 1
                elif anweisung[0] == "stop":
                    self.pc = self.pc + 1

    def verarbeiteZuweisung(self, anweisung):
        variable = anweisung[1][1]
        term = anweisung[2]
        self.variablenzustand.setVariable(variable, self.wertTerm(term))

    def verarbeiteGoto(self, anweisung):
        label = anweisung[1]
        self.pc = 0
        while self.programm[self.pc][0] != label:
            self.pc = self.pc + 1
            
    def wertOperand(self, operand):
        if operand[0] == "ZAHL":
            return int(operand[1])
        elif operand[0] == "VAR":
            return self.variablenzustand.getVariable(operand[1])

    def wertTerm(self, term):
        if len(term) == 1:
            return self.wertOperand(term[0])
        else:
            wertOperand1 = self.wertOperand(term[1])
            wertOperand2 = self.wertOperand(term[2])
            op = term[0]
            if op == "+":
                return wertOperand1 + wertOperand2
            elif op == "-":
                return wertOperand1 - wertOperand2

    def verarbeiteBedingung(self, bedingung):
        wertOperand1 = self.wertOperand(bedingung[1])
        wertOperand2 = self.wertOperand(bedingung[2])
        rel = bedingung[0]
        if rel == "!=":
            return (wertOperand1 != wertOperand2)
        elif rel == ">":
            return (wertOperand1 > wertOperand2)
        elif rel == "<":
            return (wertOperand1 < wertOperand2)
        elif rel == "==":
            return (wertOperand1 == wertOperand2)
