class InterpreterWhileList(object):
    def __init__(self, v):
        self.programm = None
        self.variablenzustand = v

    def setProgramm(self, p):
        self.programm = p

    def getProgramm(self):
        return self.programm

    def getVariablenzustand(self):
        return self.variablenzustand

    def anweisungAusfuehren(self):
        if self.programm != []:
            anweisung = self.programm[0]
            bezeichner = anweisung[0]
            if bezeichner == "=":
                self.verarbeiteZuweisung(anweisung)
                self.programm = self.programm[1:]
            if bezeichner == "pass":
                self.programm = self.programm[1:]
            elif bezeichner == "while":
                bedingung = anweisung[1]
                if self.verarbeiteBedingung(bedingung):
                    self.programm = anweisung[2] + self.programm
                else:
                    self.programm = self.programm[1:]
            elif bezeichner == "if":
                bedingung = anweisung[1]
                if self.verarbeiteBedingung(bedingung):
                    self.programm = anweisung[2] + self.programm[1:]
                else:
                    self.programm = anweisung[3] + self.programm[1:]

    def verarbeiteZuweisung(self, anweisung):
        variable = anweisung[1][1]
        term = anweisung[2]
        self.variablenzustand.setVariable(variable, self.wertTerm(term))

    def wertOperand(self, operand):
        if operand[0] == "ZAHL":
            return int(operand[1])
        elif operand[0] == "VAR":
            return self.variablenzustand.getVariable(operand[1])

    def wertTerm(self, term):
        if len(term) == 1:
            return self.wertOperand(term[0])
        else:
            wertOperand1 = self.wertOperand(term[1])
            wertOperand2 = self.wertOperand(term[2])
            op = term[0]
            if op == "+":
                return wertOperand1 + wertOperand2
            elif op == "-":
                return wertOperand1 - wertOperand2
                


    def verarbeiteBedingung(self, bedingung):
        wertOperand1 = self.wertOperand(bedingung[1])
        wertOperand2 = self.wertOperand(bedingung[2])
        rel = bedingung[0]
        if rel == "!=":
            return (wertOperand1 != wertOperand2)
        elif rel == ">":
            return (wertOperand1 > wertOperand2)
        elif rel == "<":
            return (wertOperand1 < wertOperand2)
        elif rel == "==":
            return (wertOperand1 == wertOperand2)
