class UebersetzerWhileList(object):
    def __init__(self):
        self.quellcode = None

    def setQuellcode(self, q):
        self.quellcode = q

    def uebersetzen(self):

        def c_programm(p):
            'programm : anweisungsfolge'
            return c_anweisungsfolge(p) 

        def c_anweisungsfolge(p):
            '''anweisungsfolge : anweisung anweisungsfolge
                               | anweisung'''
            if len(p) > 1:
                return c_anweisung(p[0]) + c_anweisungsfolge(p[1:])
            else:
                return c_anweisung(p[0])

        def c_anweisung(p):
            '''anweisung : VAR ZUW term
                         | PASS
                         | WHILE bedingung DP anweisungsfolge ENDWH
                         | IF bedingung DP anweisungsfolge ELSE DP anweisungsfolge ENDIF'''
            if p[0] == "=":
                return [(None, p)]
            elif p[0] == "pass":
                return [(None, ['noop'])]
            elif p[0] == 'while':
                ergebnis_true = c_anweisungsfolge(p[2])
                ergebnis_wh = [('.L' + str(self.zaehler), ['noop']), \
                               (None, ['if', p[1], ['goto', '.L' + str(self.zaehler+1)], ['goto', '.L' + str(self.zaehler+2)]]), \
                               ('.L' + str(self.zaehler+1), ['noop'])] + \
                               ergebnis_true + \
                              [(None, ['goto', '.L' + str(self.zaehler)]), \
                               ('.L' + str(self.zaehler+2), ['noop'])]
                self.zaehler = self.zaehler + 3
                return ergebnis_wh
            elif p[0] == 'if':
                ergebnis_true = c_anweisungsfolge(p[2])
                ergebnis_false = c_anweisungsfolge(p[3])
                ergebnis_if = [(None, ['if', p[1], ['goto', '.L' + str(self.zaehler)], ['goto', '.L' + str(self.zaehler+1)]]), \
                               ('.L' + str(self.zaehler), ['noop'])] + \
                               ergebnis_true + \
                               [(None, ['goto', '.L' + str(self.zaehler+2)])] + \
                               [('.L' + str(self.zaehler+1), ['noop'])]+ \
                               ergebnis_false + \
                               [('.L' + str(self.zaehler+2), ['noop'])]
                self.zaehler = self.zaehler + 3
                return ergebnis_if

        self.zaehler = 0
        if self.quellcode != None:
            return c_programm(self.quellcode)
        else:
            return []

