from tkinter import *
import tkinter.filedialog

class WhileGUI:

    def __init__(self, variablenzustand, scannerparserWhile, interpreterWhileList, compilerWhileList, interpreterGoto, assemblerGoto):
        # Referenzattribute zum Datenmodell
        self.variablenzustand = variablenzustand
        self.scannerparserWhile = scannerparserWhile
        self.interpreterWhileList = interpreterWhileList
        self.compilerWhileList = compilerWhileList
        self.interpreterGoto = interpreterGoto
        self.assemblerGoto = assemblerGoto

        # Erzeugung des Fensters
        self.fenster = Tk()
        self.fenster.title("MiniPython")
        self.fenster.geometry('750x620')
        # Farben
        blau = "#BDE2F3"
        rot = "#FFCFC9"
        gelb = "#FBD975"
        gruen = "#D5E88F"

        # WhileQuelltext
        self.rahmenWhile = Frame(master=self.fenster, background=gruen)
        self.rahmenWhile.place(x=5, y=5, width=300, height=250)
        # Texteditor für das Programm
        self.scrollbarWhile = Scrollbar(master=self.rahmenWhile)
        self.scrollbarWhile.place(x=280, y=8, width=10, height=197)
        self.textWhile = Text(master=self.rahmenWhile, width=32, height=12, wrap=WORD, yscrollcommand=self.scrollbarWhile.set)
        self.scrollbarWhile["command"] = self.textWhile.yview
        self.textWhile.place(x=8, y=8)
        # Programm laden
        self.buttonProgrammLaden = Button(master=self.rahmenWhile, text="laden", command=self.Button_ProgrammLaden_Click)
        self.buttonProgrammLaden.place(x=8, y=215, width=90, height=27)
        # Programm speichern
        self.buttonProgrammSpeichern = Button(master=self.rahmenWhile, text="speichern", command=self.Button_ProgrammSpeichern_Click)
        self.buttonProgrammSpeichern.place(x=106, y=215, width=90, height=27)
        # Programm übersetzen
        self.buttonProgrammKompilieren = Button(master=self.rahmenWhile, text="scannen / parsen", command=self.Button_While_Uebersetzen_Click)
        self.buttonProgrammKompilieren.place(x=204, y=215, width=90, height=27)

        # WhileList
        # Rahmen
        self.rahmenWhileList = Frame(master=self.fenster, background=gelb)
        self.rahmenWhileList.place(x=5, y=265, width=300, height=350)
        # Text-Fenster für WhileList
        self.scrollbarWhileList = Scrollbar(master=self.rahmenWhileList)
        self.scrollbarWhileList.place(x=280, y=8, width=10, height=294)
        self.textWhileList = Text(master=self.rahmenWhileList, width=32, height=18, wrap=WORD, yscrollcommand=self.scrollbarWhileList.set)
        self.scrollbarWhileList["command"] = self.textWhileList.yview
        self.textWhileList.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonWhileListAnweisungAusfuehren = Button(master=self.rahmenWhileList, text="Anw. ausführen", command=self.Button_WhileList_AnweisungAusfuehren_Click)
        self.buttonWhileListAnweisungAusfuehren.place(x=8, y=315, width=90, height=27)
        # Button Programm ausführen
        self.buttonWhileListProgrammAusfuehren = Button(master=self.rahmenWhileList, text="Prog. ausführen", command=self.Button_WhileList_ProgrammAusfuehren_Click)
        self.buttonWhileListProgrammAusfuehren.place(x=106, y=315, width=90, height=27)
        # Button Programm übersetzen
        self.buttonProgrammUebersetzen = Button(master=self.rahmenWhileList, text="Code erzeugen", command=self.Button_WhileList_Uebersetzen_Click)
        self.buttonProgrammUebersetzen.place(x=204, y=315, width=90, height=27)

        # Assembler
        # Rahmen
        self.rahmenAssembler = Frame(master=self.fenster, background=rot)
        self.rahmenAssembler.place(x=315, y=5, width=130, height=610)
        # Text-Fenster für WhileList
        self.scrollbarAssembler = Scrollbar(master=self.rahmenAssembler)
        self.scrollbarAssembler.place(x=112, y=8, width=10, height=550)
        self.textAssembler = Text(master=self.rahmenAssembler, width=11, height=34, wrap=WORD, yscrollcommand=self.scrollbarAssembler.set)
        self.scrollbarAssembler["command"] = self.textAssembler.yview
        self.textAssembler.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonAssemblerAnweisungAusfuehren = Button(master=self.rahmenAssembler, text="\u25ba", font=('Arial', 12), command=self.Button_Assembler_AnweisungAusfuehren_Click)
        self.buttonAssemblerAnweisungAusfuehren.place(x=8, y=575, width=30, height=27)
        # Button Programm ausführen
        self.buttonAssemblerProgrammAusfuehren = Button(master=self.rahmenAssembler, text="\u21bb", font=('Arial', 12), command=self.Button_Assembler_ProgrammAusfuehren_Click)
        self.buttonAssemblerProgrammAusfuehren.place(x=50, y=575, width=30, height=27)
        # Button Programm ausführen
        self.buttonAssemblerProgrammErzeugen = Button(master=self.rahmenAssembler, text="\u25a0", font=('Arial', 12), command=self.Button_Assembler_AusfuehrungStoppen_Click)
        self.buttonAssemblerProgrammErzeugen.place(x=92, y=575, width=30, height=27)
        #self.goto_assembler = "goto"

        # Variablenzustand
        # Rahmen
        self.variablenZustand = Frame(master=self.fenster, background=rot)
        self.variablenZustand.place(x=455, y=5, width=130, height=610)
        # Text-Fenster für Variablenzustand
        self.scrollbarVariablenZustand = Scrollbar(master=self.variablenZustand)
        self.scrollbarVariablenZustand.place(x=112, y=8, width=10, height=550)
        self.textVariablenZustand = Text(master=self.variablenZustand, width=11, height=34, wrap=WORD, yscrollcommand=self.scrollbarVariablenZustand.set)
        self.scrollbarVariablenZustand["command"] = self.textVariablenZustand.yview
        self.textVariablenZustand.place(x=8, y=8)

        # Button initialisieren
        self.buttonInitialisieren = Button(master=self.variablenZustand, text="initialisieren", command=self.buttonInitialisierenClick)
        self.buttonInitialisieren.place(x=8, y=575, width=115, height=27)

        # Bonsai
        # Rahmen
        self.rahmenBonsai = Frame(master=self.fenster, background=blau)
        self.rahmenBonsai.place(x=595, y=5, width=150, height=610)
        # Text-Fenster für WhileList
        self.scrollbarBonsai = Scrollbar(master=self.rahmenBonsai)
        self.scrollbarBonsai.place(x=132, y=8, width=10, height=550)
        self.textBonsai = Text(master=self.rahmenBonsai, width=13, height=34, wrap=WORD, yscrollcommand=self.scrollbarBonsai.set)
        self.scrollbarBonsai["command"] = self.textBonsai.yview
        self.textBonsai.place(x=8, y=8)
        # Button Anweisung ausführen
        self.buttonBonsaiSpeichen = Button(master=self.rahmenBonsai, text="speichern", command=self.Button_BonsaiSpeichern_Click)
        self.buttonBonsaiSpeichen.place(x=8, y=575, width=135, height=27)

    def aktualisiereVariablenzustand(self):
        self.textVariablenZustand.delete('1.0', END)
        p = self.variablenzustand.variablen
        if p != None:
            for v in p:
                self.textVariablenZustand.insert(END, str(v[0]) + ' -> ' + str(v[1]) + '\n')

    def aktualisiereWhileListCode(self):
        self.textWhileList.delete('1.0', END)
        p = self.interpreterWhileList.getProgramm()
        if p != None:
            for a in p:
                self.textWhileList.insert(END, str(a) + '\n' + '\n')

    def aktualisiereBonsaiCode(self):
        self.textBonsai.delete('1.0', END)
        self.textBonsai.insert(END, self.compilerWhileList.getBonsaiText())

    def buttonInitialisierenClick(self):
        self.variablenzustand.initVariablen([])
        self.aktualisiereVariablenzustand()

    def Button_While_Uebersetzen_Click(self):
        quelltext = self.textWhile.get('1.0', END)
        if len(quelltext) != 0:
            strukturbaum = self.scannerparserWhile.parse(quelltext, debug=0)
        else:
            strukturbaum = []
        self.interpreterWhileList.setProgramm(strukturbaum)
        self.aktualisiereWhileListCode()

    def Button_ProgrammLaden_Click(self):
        self.datei = tkinter.filedialog.askopenfile()
        self.textWhile.delete(1.0, END)
        if self.datei:
            self.textWhile.insert(1.0, self.datei.read())
            self.datei.close()

    def Button_ProgrammSpeichern_Click(self):
        self.datei = tkinter.filedialog.asksaveasfile()
        if self.datei:
            self.datei.write(self.textWhile.get(1.0, END) )
            self.datei.close()

    def Button_WhileList_AnweisungAusfuehren_Click(self):
        self.interpreterWhileList.anweisungAusfuehren()
        self.aktualisiereWhileListCode()
        self.aktualisiereVariablenzustand()


    def Button_WhileList_ProgrammAusfuehren_Click(self):
        self.aktualisiereVariablenzustand()
        self.aktualisiereWhileListCode()
        if self.interpreterWhileList.getProgramm() != []:
            self.interpreterWhileList.anweisungAusfuehren()
            self.fenster.after(1000, self.Button_WhileList_ProgrammAusfuehren_Click)

    def aktualisiereAssemblerProgrammCode(self):
        self.textAssembler.delete('1.0', END)
        p = self.interpreterGoto.getProgramm()
        pc = self.interpreterGoto.getPC()
        for i in range(len(p)):
            befehl = p[i]
            if i != pc:
                self.textAssembler.insert(END, "" + str(befehl[0]) + ' ' + str(befehl[1]) + '\n')
            else:
                self.textAssembler.insert(END, "> " + str(befehl[0]) + ' ' + str(befehl[1]) + '\n')
 
    def Button_WhileList_Uebersetzen_Click(self):
        self.compilerWhileList.setQuellcode(self.interpreterWhileList.getProgramm())
        self.compilerWhileList.uebersetzen()
        p = self.compilerWhileList.getProgramm()
        self.interpreterGoto.initProgramm(p)
        self.aktualisiereVariablenzustand()
        self.aktualisiereAssemblerProgrammCode()
        self.compilerWhileList.erzeugeBonsaiCode()
        self.compilerWhileList.erzeugeBonsaiText()
        self.aktualisiereBonsaiCode()
        

    def Button_Assembler_AnweisungAusfuehren_Click(self):
        self.interpreterGoto.anweisungAusfuehren()
        self.aktualisiereVariablenzustand()
        self.aktualisiereAssemblerProgrammCode()

    def Button_Assembler_ProgrammAusfuehren_Click(self):
        self.aktualisiereVariablenzustand()
        self.aktualisiereAssemblerProgrammCode()
        if self.interpreterGoto.getProgramm()[self.interpreterGoto.getPC()][0] != 'hlt':
            self.interpreterGoto.anweisungAusfuehren()
            self.id = self.fenster.after(100, self.Button_Assembler_ProgrammAusfuehren_Click)

    def Button_Assembler_AusfuehrungStoppen_Click(self):
        self.fenster.after_cancel(self.id)


    def Button_BonsaiSpeichern_Click(self):
        self.datei = tkinter.filedialog.asksaveasfile()
        if self.datei:
            self.datei.write(self.compilerWhileList.getBonsaiText())
            self.datei.close()

#-------------------------------------------------------------

import ply.lex as lex
import ply.yacc as yacc
from syntaxWhile import *
# Erzeugung des Scanners
scannerWhile = lex.lex(debug=0)
# Erzeugung des Parsers
parserWhile = yacc.yacc(debug=False)




from interpreterWhileList import *
from interpreterGoto import *
from uebersetzerWhileList import *
from variablenzustand import *


from assemblerGoto import *


# Erzeugung des GUI-Objekts

variablenzustand = Variablenzustand()
interpreterWhileList = InterpreterWhileList(variablenzustand)
interpreterGoto = InterpreterGoto(variablenzustand)
uebersetzerWhileList = UebersetzerWhileList(variablenzustand)

assemblerGoto = AssemblerGoto(variablenzustand)

whileGUI = WhileGUI(variablenzustand, parserWhile, interpreterWhileList, uebersetzerWhileList, interpreterGoto, assemblerGoto)
whileGUI.fenster.mainloop()
