class InterpreterGoto(object):
    def __init__(self, v):
        self.programm = None
        self.pc = 0
        self.variablenzustand = v

    def initProgramm(self, p):
        self.programm = p
        self.pc = 0

    def getProgramm(self):
        return self.programm

    def getPC(self):
        return self.pc

    def anweisungAusfuehren(self):
        z = self.variablenzustand
        c = self.programm
        # Auswertung des Codes
        PC = self.pc                     # Programmzähler PC auf 0. Befehl setzen
        op = c[PC][0]                    # Opcode des Befehls
        addr = c[PC][1]                  # Adressteil des Befehls
        
        if op == 'inc':
            z.setVariable(addr, z.getVariable(addr) + 1)
            PC = PC + 1
        elif op == 'dec':
            if z.getVariable(addr) > 0:
                z.setVariable(addr, z.getVariable(addr) - 1)
            else:
                print('Fehler - kein Dekrementieren möglich')
                exit() 
            PC = PC + 1
        elif op == 'jmp':
            jmp = c[PC][1]
            PC = PC + eval(jmp)
        elif op == 'tst':           
            if z.getVariable(addr) == 0:
                PC = PC + 2
            else:
                PC = PC + 1
        elif op == 'hlt':
            pass
        else:
            print('unbekannter Befehl')
        self.pc = PC


    def programmAusfuehren(self):
        while self.programm[self.pc][0] != 'hlt':
            self.anweisungAusfuehren()
            #self.aktualisiereVariablenzustand()
        



