# reservierte Wörter

reserved = {
   'if' : 'IF',
   'else' : 'ELSE',
   'while' : 'WHILE',
   'pass': 'PASS'
}

# Namen der Token

tokens = ['VAR', 'ZAHL', 'NULL', 'ZUW', 'PLUS', 'MINUS', 'GL', 'UG', 'KL', 'KLGL', 'DP', 'END']
tokens = tokens + list(reserved.values())

# Beschreibung der Token

def t_VAR(t):
    r'[a-z][a-z0-9]*'
    t.type = reserved.get(t.value, 'VAR') # Überprüfung auf reservierte Wörter
    return t

t_ZAHL    = r'[\+|-]?[1-9][0-9]*'
t_NULL    = r'0'
t_ZUW     = r'='
t_PLUS    = r'\+'
t_MINUS   = r'-'
t_GL      = r'=='
t_UG      = r'!='
t_KL      = r'\<'
t_KLGL      = r'\<='
t_DP      = r':'
t_END   = r'\#end'

# Ignorierte Zeichen
t_ignore = " \t"

def t_newline(t):
    r'\n+'
    t.lexer.lineno = t.lexer.lineno + t.value.count("\n")

def t_error(t):
    print("Illegal character '%s'" % t.value[0])
    t.lexer.skip(1)

# erweiterte Produktionen

def p_anweisungsfolge_programm(p):
    'programm : anweisungsfolge'
    p[0] = p[1]

def p_anweisungsfolge_anweisung_anweisungsfolge(p):
    'anweisungsfolge : anweisung anweisungsfolge'
    p[0] = [p[1]] + p[2]

def p_anweisungsfolge_anweisung(p):
    'anweisungsfolge : anweisung'
    p[0] = [p[1]]

def p_anweisung_zuw(p):
    'anweisung : zuweisung'
    p[0] = p[1]

def p_anweisung_pass(p):
    'anweisung : PASS'
    p[0] = [p[1]]

def p_anweisung_wh(p):
    'anweisung : WHILE bedingung DP anweisungsfolge END'
    p[0] = [p[1]] + [p[2]] + [p[4]]

def p_anweisung_if(p):
    'anweisung : IF bedingung DP anweisungsfolge ELSE DP anweisungsfolge END'
    p[0] = [p[1]] + [p[2]] + [p[4]] + [p[7]]

def p_zuweisung(p):
    'zuweisung : VAR ZUW term'
    p[0] = [p[2], ('VAR', p[1]), p[3]]

def p_term_var_op_zahl(p):
    'term : VAR op zahl'
    p[0] = [p[2], ('VAR', p[1]), ('ZAHL', p[3])]

def p_term_var_op_var(p):
    'term : VAR op VAR'
    p[0] = [p[2], ('VAR', p[1]), ('VAR', p[3])]

def p_term_zahl(p):
    'term : zahl'
    p[0] = [('ZAHL', p[1])]

def p_term_var(p):
    'term : VAR'
    p[0] = [('VAR', p[1])]

def p_zahl_null(p):
    'zahl : NULL'
    p[0] = p[1]

def p_zahl_nicht_null(p):
    'zahl : ZAHL'
    p[0] = p[1]

def p_bedingung_null(p):
    'bedingung : VAR rel0 NULL'
    p[0] = [p[2], ('VAR', p[1]), ('ZAHL', p[3])]

def p_bedingung(p):
    'bedingung : VAR rel VAR'
    p[0] = [p[2], ('VAR', p[1]), ('VAR', p[3])]

def p_op_plus(p):
    'op : PLUS'
    p[0] = p[1]

def p_op_minus(p):
    'op : MINUS'
    p[0] = p[1]

def p_rel_gleich_null(p):
    'rel0 : GL'
    p[0] = p[1]

def p_rel_ungleich_null(p):
    'rel0 : UG'
    p[0] = p[1]

def p_rel_gleich(p):
    'rel : GL'
    p[0] = p[1]

def p_rel_ungleich(p):
    'rel : UG'
    p[0] = p[1]

def p_rel_kleiner(p):
    'rel : KL'
    p[0] = p[1]

def p_rel_kleinergleich(p):
    'rel : KLGL'
    p[0] = p[1]


# Fehlermeldung
def p_error(p):
    print("Syntaxfehler!")



