import greenfoot.*;  // imports Actor, World, Greenfoot, GreenfootImage

import java.util.List;
import java.util.ArrayList;

/**
 * 
 * @author Michael Kolling, changed by Thomas Karp
 * @version 1.0.2
 */
public class Hase extends Actor
{
    private static final int OBEN = 0;
    private static final int RECHTS = 1;
    private static final int UNTEN = 2;    
    private static final int LINKS = 3;

    int richtung; // aktuelle Richtung
    int schritte;

    /**
     * Erzeuge einen Hasen
     */
    public Hase()
    {
        setRichtung(RECHTS);
        schritte = 0;
    }

    /**
     * Esse eine Karotte.
     */
    public void esseKarotte()
    {
        Actor karotte = getOneObjectAtOffset(0, 0, Karotte.class);
        if(karotte != null) {
            getWorld().removeObject(karotte);
        }
    }

    /**
     * Bewege Dich einen Schritt nach vorne falls mglich. Sonst tue nichts.
     */
    public void laufe()
    {
        if (kannLaufen()) {
            schritte++;
            switch(richtung) {
                case UNTEN :
                setLocation(getX(), getY() + 1);
                break;
                case RECHTS :
                setLocation(getX() + 1, getY());
                break;
                case OBEN :
                setLocation(getX(), getY() - 1);
                break;
                case LINKS :
                setLocation(getX() - 1, getY());
                break;
            }
        }
    }

    /**
     * berprfe, ob Hase nach vorne laufen kann.
     */
    public boolean kannLaufen()
    {
        World myWorld = getWorld();
        int x = getX();
        int y = getY();
        switch(richtung) {
            case UNTEN :
            y++;
            break;
            case RECHTS :
            x++;
            break;
            case OBEN :
            y--;
            break;
            case LINKS :
            x--;
            break;
        }

        if (x >= myWorld.getWidth() || y >= myWorld.getHeight()) {
            return false;
        }
        else if (x < 0 || y < 0) {
            return false;
        }

        List steine = myWorld.getObjectsAt(x, y, Elefant.class);
        if(steine.isEmpty()) {
            return true;
        }
        else {
            return false;
        }
    }

    /**
     * Nach links drehen.
     */
    public void linksDrehen()
    {
        switch(richtung) {
            case UNTEN :
            setRichtung(RECHTS);
            break;
            case RECHTS :
            setRichtung(OBEN);
            break;
            case OBEN :
            setRichtung(LINKS);
            break;
            case LINKS :
            setRichtung(UNTEN);
            break;
        }
    }

    /**
     * Setze Richtung des Hasen.
     */
    public void setRichtung(int richtung)
    {
        if(richtung >= 0 && richtung <= 3)
            this.richtung = richtung;
        switch(richtung) {
            case UNTEN :
            setRotation(90);
            setImage("hase.png");
            break;
            case RECHTS :
            setRotation(0);
            setImage("hase.png");
            break;
            case OBEN :
            setImage("hase.png");
            getImage().mirrorHorizontally();
            setRotation(90);
            break;
            case LINKS :
            setImage("hase.png");
            getImage().mirrorHorizontally();
            setRotation(0);
            break;
            default :
            break;
        }
    }

    /**
     * Gib die Zahl der gelaufenen Schritte zurck
     */
    public int gelaufeneSchritte()
    {
        return schritte;
    }

    private void steuern()
    {
        if(Greenfoot.isKeyDown("left") || Greenfoot.isKeyDown("space"))
            linksDrehen();

        laufe();
        esseKarotte();
        getWorld().showText("Schritte: " + schritte, 1, 0);
        if(getWorld().getObjects(Karotte.class).size() == 0) {
            getWorld().showText("Du hast alle Karotten gefuttert!!!", 3, 3);
            Greenfoot.stop();
        }
    }

    /** 
     * Tu, was ein Hase so tut
     */
    // public void act()
    // {
        // steuern();
    // }
}