import greenfoot.*;  // imports Actor, World, Greenfoot, GreenfootImage

import java.util.Random;

/**
 * @author Michael Kolling, changed by Thomas Karp
 * @version 1.0.4
 */
public class HasenWelt extends World
{

    /**
     * Erzeuge eine Welt.
     */
    public HasenWelt() 
    {
        super(8, 8, 60);
        setBackground("cell.jpg");
        setPaintOrder(Hase.class, Karotte.class, Elefant.class);
        Greenfoot.setSpeed(30);
        //erzeugeStartbelegung();
    }

    /**
     * Erzeuge Standardbelegung
     */
    public void erzeugeStartbelegung()
    {
        erzeugeObjekte(1, 5, 15);
    }

    /**
     * Erzeuge Hasen, Elefanten und Karotten.
     */    
    public void erzeugeObjekte(int hasen, int elefanten, int karotten)
    {
        erzeugeHasen(hasen);
        erzeugeElefanten(elefanten);
        erzeugeKarotten(karotten);
    }

    /**
     * Erzeuge an zuflligen Orten Karotten. Elefanten werden vermieden.
     */
    private void erzeugeKarotten(int wieViele)
    {
        int alteElefanten = getObjects(Elefant.class).size();
        int alteKarotten = getObjects(Karotte.class).size();
        for(int i=0; i<wieViele; i++) {
            Karotte karotte = new Karotte();
            int x = Greenfoot.getRandomNumber(getWidth());
            int y = Greenfoot.getRandomNumber(getHeight());
            if(wieViele + alteKarotten + alteElefanten <= 64) // Kollision nur vermeiden, wenn theoretisch mglich
                while(getObjectsAt(x, y, Elefant.class).size() > 0 || getObjectsAt(x, y, Karotte.class).size() > 0) {
                    x = Greenfoot.getRandomNumber(getWidth());
                    y = Greenfoot.getRandomNumber(getHeight());
                }
            addObject(karotte, x, y);
        }
    }

    /**
     * Erzeuge an zuflligen Orten Elefanten. Karotten werden vermieden.
     */
    private void erzeugeElefanten(int wieViele)
    {
        int alteElefanten = getObjects(Elefant.class).size();
        int alteKarotten = getObjects(Karotte.class).size();
        for(int i=0; i<wieViele; i++) {
            Elefant e = new Elefant();
            int x = Greenfoot.getRandomNumber(getWidth());
            int y = Greenfoot.getRandomNumber(getHeight());
            if(wieViele + alteKarotten + alteElefanten <= 64) // Kollision nur vermeiden, wenn theoretisch mglich
                while(getObjectsAt(x, y, Elefant.class).size() > 0 || getObjectsAt(x, y, Karotte.class).size() > 0) {
                    x = Greenfoot.getRandomNumber(getWidth());
                    y = Greenfoot.getRandomNumber(getHeight());
                }
            addObject(e, x, y);
        }
    }

    /**
     * Erzeuge an zuflligen Orten Hasen.
     */
    private void erzeugeHasen(int wieViele)
    {
        for(int i=0; i<wieViele; i++) {
            Hase wombat = new Hase();
            int x = Greenfoot.getRandomNumber(getWidth());
            int y = Greenfoot.getRandomNumber(getHeight());
            addObject(wombat, x, y);
        }
    }

}