/*
 * Decompiled with CFR 0.152.
 */
import greenfoot.Actor;
import greenfoot.Greenfoot;
import greenfoot.World;
import java.util.List;

public class Hase
extends Actor {
    private static final int OBEN = 0;
    private static final int RECHTS = 1;
    private static final int UNTEN = 2;
    private static final int LINKS = 3;
    private int richtung;
    private int schritte;

    public Hase() {
        this.setRichtung(1);
        this.schritte = 0;
    }

    public void esseKarotte() {
        Actor karotte = this.getOneObjectAtOffset(0, 0, Karotte.class);
        if (karotte != null) {
            this.getWorld().removeObject(karotte);
        }
    }

    public void laufe() {
        if (!this.kannLaufen()) {
            return;
        }
        switch (this.richtung) {
            case 2: {
                this.setLocation(this.getX(), this.getY() + 1);
                break;
            }
            case 1: {
                this.setLocation(this.getX() + 1, this.getY());
                break;
            }
            case 0: {
                this.setLocation(this.getX(), this.getY() - 1);
                break;
            }
            case 3: {
                this.setLocation(this.getX() - 1, this.getY());
            }
        }
    }

    public boolean kannLaufen() {
        World myWorld = this.getWorld();
        int x = this.getX();
        int y = this.getY();
        switch (this.richtung) {
            case 2: {
                ++y;
                break;
            }
            case 1: {
                ++x;
                break;
            }
            case 0: {
                --y;
                break;
            }
            case 3: {
                --x;
            }
        }
        if (x >= myWorld.getWidth() || y >= myWorld.getHeight()) {
            return false;
        }
        if (x < 0 || y < 0) {
            return false;
        }
        List<Elefant> steine = myWorld.getObjectsAt(x, y, Elefant.class);
        return steine.isEmpty();
    }

    public void linksDrehen() {
        switch (this.richtung) {
            case 2: {
                this.setRichtung(1);
                break;
            }
            case 1: {
                this.setRichtung(0);
                break;
            }
            case 0: {
                this.setRichtung(3);
                break;
            }
            case 3: {
                this.setRichtung(2);
            }
        }
    }

    public void setRichtung(int richtung) {
        if (richtung >= 0 && richtung <= 3) {
            this.richtung = richtung;
        }
        switch (richtung) {
            case 2: {
                this.setRotation(90);
                this.setImage("hase.png");
                break;
            }
            case 1: {
                this.setRotation(0);
                this.setImage("hase.png");
                break;
            }
            case 0: {
                this.setImage("hase.png");
                this.getImage().mirrorHorizontally();
                this.setRotation(90);
                break;
            }
            case 3: {
                this.setImage("hase.png");
                this.getImage().mirrorHorizontally();
                this.setRotation(0);
                break;
            }
        }
    }

    public int gegangeneSchritte() {
        return this.schritte;
    }

    private void steuern() {
        if (Greenfoot.isKeyDown("left") || Greenfoot.isKeyDown("space")) {
            this.linksDrehen();
        }
        if (this.kannLaufen()) {
            this.laufe();
            ++this.schritte;
        }
        this.esseKarotte();
        this.getWorld().showText("Schritte: " + this.schritte, 1, 0);
        if (this.getWorld().getObjects(Karotte.class).size() == 0) {
            this.getWorld().showText("Du hast alle Karotten gefuttert!!!", 3, 3);
            Greenfoot.stop();
        }
    }

    @Override
    public void act() {
        this.steuern();
    }
}

