/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.utility.Debug;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class PauseSimulationAction
extends AbstractAction
implements SimulationListener {
    private static final String iconFile = "pause.png";
    private static PauseSimulationAction instance = new PauseSimulationAction();
    private Simulation simulation;
    protected boolean stateOnDebugResume;
    private Runnable actionListener;

    public static PauseSimulationAction getInstance() {
        return instance;
    }

    private PauseSimulationAction() {
        super(Config.getString("pause.simulation"), new ImageIcon(PauseSimulationAction.class.getClassLoader().getResource(iconFile)));
    }

    public void attachSimulation(Simulation simulation) {
        this.simulation = simulation;
        simulation.addSimulationListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.simulation == null) {
            Debug.reportError((String)"attempt to pause a simulation while none exists.");
        } else {
            if (this.actionListener != null) {
                this.actionListener.run();
            }
            this.simulation.setPaused(true);
        }
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        int eventType = e.getType();
        if (eventType == 1) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = false;
                this.setEnabled(false);
            });
        } else if (eventType == 0) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = true;
                this.setEnabled(true);
            });
        } else if (eventType == 3) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = false;
                this.setEnabled(false);
            });
        } else if (eventType == 5) {
            EventQueue.invokeLater(() -> {
                this.stateOnDebugResume = this.isEnabled();
                this.setEnabled(false);
            });
        } else if (eventType == 6) {
            EventQueue.invokeLater(() -> this.setEnabled(this.stateOnDebugResume));
        }
    }

    public void setActionListener(Runnable actionListener) {
        this.actionListener = actionListener;
    }
}

