/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.sound.SoundExceptionHandler;
import greenfoot.sound.SoundUtils;
import greenfoot.sound.TimeTracker;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AudioLine {
    private static final int EXTRA_SLEEP_DELAY = 50;
    private volatile SourceDataLine line;
    private AudioFormat format;
    private long totalWritten;
    private boolean open;
    private boolean started;
    private int masterVolume;
    private boolean writing;
    private boolean reset;
    private TimeTracker timeTracker;

    private static void printDebug(String s) {
    }

    public AudioLine(SourceDataLine line, AudioFormat format) {
        this.line = line;
        this.format = format;
        this.timeTracker = new TimeTracker();
    }

    public synchronized void open() throws LineUnavailableException, IllegalArgumentException, IllegalStateException, SecurityException {
        if (!this.open) {
            this.line.open(this.format);
            this.open = true;
            this.reset = true;
        }
    }

    public synchronized void close() {
        if (this.open) {
            this.open = false;
            this.reset();
            this.line.close();
        }
    }

    public synchronized void start() {
        if (!this.started && this.open) {
            this.line.start();
            this.started = true;
            if (this.getTimeLeft() > 0L) {
                this.timeTracker.start();
            }
        }
    }

    public synchronized void stop() {
        if (this.open) {
            this.notifyAll();
            this.started = false;
            this.line.stop();
            this.timeTracker.pause();
        }
    }

    public synchronized void reset() {
        AudioLine.printDebug("reset() start");
        if (this.open) {
            if (this.started) {
                this.line.stop();
            }
            if (!this.reset) {
                this.line.flush();
            }
            this.totalWritten = 0L;
            this.started = false;
            this.timeTracker.reset();
            this.notifyAll();
        }
        this.reset = true;
        AudioLine.printDebug("reset() end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] b, int off, int len) {
        AudioLine audioLine = this;
        synchronized (audioLine) {
            if (!this.open) {
                return 0;
            }
            this.writing = true;
            this.started = true;
            this.reset = false;
            this.timeTracker.start();
        }
        this.line.start();
        int written = this.line.write(b, off, len);
        AudioLine audioLine2 = this;
        synchronized (audioLine2) {
            this.notifyAll();
            this.writing = false;
            if (!this.reset) {
                this.totalWritten += (long)written;
            } else if (this.reset && this.open) {
                this.line.flush();
            }
            return written;
        }
    }

    public synchronized boolean drain() {
        AudioLine.printDebug("Draining start");
        AudioLine.printDebug(" totalWritten: " + this.totalWritten);
        long timeLeft = this.getTimeLeft();
        while (timeLeft > 0L && this.open) {
            AudioLine.printDebug(" timeLeft: " + timeLeft);
            if (this.started && timeLeft > 0L) {
                try {
                    this.wait(timeLeft);
                }
                catch (InterruptedException interruptedException) {}
            } else if (!this.started || this.writing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            timeLeft = this.getTimeLeft();
        }
        AudioLine.printDebug("Draining end: " + timeLeft);
        return timeLeft <= 0L;
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    private synchronized long getTimeLeft() {
        return SoundUtils.getTimeToPlayBytes(this.totalWritten, this.format) - this.timeTracker.getTimeTracked() + 50L;
    }

    public long getLongFramePosition() {
        return this.line.getLongFramePosition();
    }

    public synchronized void setVolume(int masterVolume) {
        this.masterVolume = masterVolume;
        try {
            this.open();
            if (this.line != null && this.line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                FloatControl volume = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                float val = SoundUtils.convertMinMax(masterVolume, volume.getMinimum(), volume.getMaximum());
                volume.setValue(val);
            }
        }
        catch (LineUnavailableException ex) {
            SoundExceptionHandler.handleLineUnavailableException(ex);
        }
    }

    public synchronized int getVolume() {
        return this.masterVolume;
    }
}

