/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.Actor;
import greenfoot.collision.CollisionChecker;
import java.awt.Graphics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class CollisionProfiler
implements CollisionChecker {
    private static boolean to_console = true;
    private static boolean verbose = true;
    private static final int MAX_SEQ_COUNT = 100;
    private CollisionChecker checker;
    private long addObjectTime;
    private long removeObjectTime;
    private long updateObjectLocationTime;
    private long updateObjectSizeTime;
    private long getObjectsAtTime;
    private long getIntersectingObjectsTime;
    private long getObjectsInRangeTime;
    private long getNeighboursTime;
    private long getObjectsInDirectionTime;
    private long getObjectsTime;
    private long getOneObjectAtTime;
    private long getOneIntersectingObjectTime;
    private long getObjectsListTime;
    private int sequenceCount;
    private int sequences;
    private PrintStream fileStream;
    private int objectCount;

    public CollisionProfiler(CollisionChecker checker) {
        this.checker = checker;
    }

    @Override
    public void initialize(int width, int height, int cellSize, boolean wrap) {
        this.checker.initialize(width, height, cellSize, wrap);
        if (to_console) {
            this.fileStream = System.out;
        } else {
            File f = new File(System.getProperty("user.home"));
            f = new File(f, "profile.txt");
            try {
                f.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                this.fileStream = new PrintStream(f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void addObject(Actor actor) {
        long t1 = System.nanoTime();
        this.checker.addObject(actor);
        long t2 = System.nanoTime();
        this.addObjectTime += t2 - t1;
    }

    @Override
    public synchronized void removeObject(Actor object) {
        long t1 = System.nanoTime();
        this.checker.removeObject(object);
        long t2 = System.nanoTime();
        this.removeObjectTime += t2 - t1;
    }

    @Override
    public synchronized void updateObjectLocation(Actor object, int oldX, int oldY) {
        long t1 = System.nanoTime();
        this.checker.updateObjectLocation(object, oldX, oldY);
        long t2 = System.nanoTime();
        this.updateObjectLocationTime += t2 - t1;
    }

    @Override
    public synchronized void updateObjectSize(Actor object) {
        long t1 = System.nanoTime();
        this.checker.updateObjectSize(object);
        long t2 = System.nanoTime();
        this.updateObjectSizeTime += t2 - t1;
    }

    @Override
    public <T extends Actor> List<T> getObjectsAt(int x, int y, Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getObjectsAt(x, y, cls);
        long t2 = System.nanoTime();
        this.getObjectsAtTime += t2 - t1;
        return l;
    }

    @Override
    public <T extends Actor> List<T> getIntersectingObjects(Actor actor, Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getIntersectingObjects(actor, cls);
        long t2 = System.nanoTime();
        this.getIntersectingObjectsTime += t2 - t1;
        return l;
    }

    @Override
    public <T extends Actor> List<T> getObjectsInRange(int x, int y, int r, Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getObjectsInRange(x, y, r, cls);
        long t2 = System.nanoTime();
        this.getObjectsInRangeTime += t2 - t1;
        return l;
    }

    @Override
    public <T extends Actor> List<T> getNeighbours(Actor actor, int distance, boolean diag, Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getNeighbours(actor, distance, diag, cls);
        long t2 = System.nanoTime();
        this.getNeighboursTime += t2 - t1;
        return l;
    }

    @Override
    public <T extends Actor> List<T> getObjectsInDirection(int x, int y, int angle, int length, Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getObjectsInDirection(x, y, angle, length, cls);
        long t2 = System.nanoTime();
        this.getObjectsInDirectionTime += t2 - t1;
        return l;
    }

    @Override
    public synchronized <T extends Actor> List<T> getObjects(Class<T> cls) {
        long t1 = System.nanoTime();
        List<T> l = this.checker.getObjects(cls);
        long t2 = System.nanoTime();
        this.getObjectsTime += t2 - t1;
        return l;
    }

    @Override
    public List<Actor> getObjectsList() {
        long t1 = System.nanoTime();
        List<Actor> l = this.checker.getObjectsList();
        long t2 = System.nanoTime();
        this.getObjectsListTime += t2 - t1;
        return l;
    }

    @Override
    public void startSequence() {
        this.checker.startSequence();
        ++this.sequenceCount;
        this.objectCount += this.checker.getObjects(null).size();
        if (this.sequenceCount > 100) {
            this.printTimes();
            this.addObjectTime = 0L;
            this.removeObjectTime = 0L;
            this.updateObjectLocationTime = 0L;
            this.updateObjectSizeTime = 0L;
            this.getObjectsAtTime = 0L;
            this.getIntersectingObjectsTime = 0L;
            this.getObjectsInRangeTime = 0L;
            this.getNeighboursTime = 0L;
            this.getObjectsInDirectionTime = 0L;
            this.getObjectsTime = 0L;
            this.getOneObjectAtTime = 0L;
            this.getOneIntersectingObjectTime = 0L;
            this.getObjectsListTime = 0L;
            this.objectCount = 0;
            this.sequenceCount = 0;
        }
        this.fileStream.flush();
    }

    private void printTimes() {
        ++this.sequences;
        if (verbose) {
            this.fileStream.println("Sequence # " + this.sequences);
        }
        long totalTime = 0L;
        totalTime += this.addObjectTime;
        totalTime += this.removeObjectTime;
        totalTime += this.updateObjectLocationTime;
        totalTime += this.updateObjectSizeTime;
        totalTime += this.getObjectsAtTime;
        totalTime += this.getIntersectingObjectsTime;
        totalTime += this.getObjectsInRangeTime;
        totalTime += this.getNeighboursTime;
        totalTime += this.getObjectsInDirectionTime;
        totalTime += this.getObjectsTime;
        totalTime += this.getOneObjectAtTime;
        totalTime += this.getOneIntersectingObjectTime;
        if (verbose) {
            this.fileStream.println("addObjectTime                : " + this.addObjectTime);
            this.fileStream.println("removeObjectTime             : " + this.removeObjectTime);
            this.fileStream.println("updateObjectLocationTime     : " + this.updateObjectLocationTime);
            this.fileStream.println("updateObjectSizeTime         : " + this.updateObjectSizeTime);
            this.fileStream.println("getObjectsAtTime             : " + this.getObjectsAtTime);
            this.fileStream.println("getIntersectingObjectsTime   : " + this.getIntersectingObjectsTime);
            this.fileStream.println("getObjectsInRanageTime       : " + this.getObjectsInRangeTime);
            this.fileStream.println("getNeighboursTime            : " + this.getNeighboursTime);
            this.fileStream.println("getObjectsInDirectionTime    : " + this.getObjectsInDirectionTime);
            this.fileStream.println("getObjectsTime               : " + this.getObjectsTime);
            this.fileStream.println("getOneObjectAtTime           : " + this.getOneObjectAtTime);
            this.fileStream.println("getOneIntersectingObjectTime : " + this.getOneIntersectingObjectTime);
        }
        this.fileStream.println(totalTime + "," + this.objectCount / this.sequenceCount);
        this.fileStream.println("========================");
    }

    @Override
    public <T extends Actor> T getOneObjectAt(Actor actor, int dx, int dy, Class<T> cls) {
        long t1 = System.nanoTime();
        T o = this.checker.getOneObjectAt(actor, dx, dy, cls);
        long t2 = System.nanoTime();
        this.getOneObjectAtTime += t2 - t1;
        return o;
    }

    @Override
    public <T extends Actor> T getOneIntersectingObject(Actor object, Class<T> cls) {
        long t1 = System.nanoTime();
        T o = this.checker.getOneIntersectingObject(object, cls);
        long t2 = System.nanoTime();
        this.getOneIntersectingObjectTime += t2 - t1;
        return o;
    }

    @Override
    public void paintDebug(Graphics g) {
    }
}

