/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision.ibsp;

import greenfoot.Actor;
import greenfoot.collision.ibsp.BSPNode;
import greenfoot.collision.ibsp.IBSPColChecker;

public final class ActorNode {
    private Actor actor;
    private BSPNode node;
    private ActorNode next;
    private ActorNode prev;
    private boolean mark;

    public ActorNode(Actor actor, BSPNode node) {
        ActorNode first;
        this.actor = actor;
        this.node = node;
        this.next = first = IBSPColChecker.getNodeForActor(actor);
        IBSPColChecker.setNodeForActor(actor, this);
        if (this.next != null) {
            this.next.prev = this;
        }
        this.mark = true;
    }

    public void clearMark() {
        this.mark = false;
    }

    public void mark() {
        this.mark = true;
    }

    public boolean checkMark() {
        boolean markVal = this.mark;
        this.mark = false;
        return markVal;
    }

    public Actor getActor() {
        return this.actor;
    }

    public BSPNode getBSPNode() {
        return this.node;
    }

    public ActorNode getNext() {
        return this.next;
    }

    public void remove() {
        this.removed();
        this.node.actorRemoved(this.actor);
    }

    public void removed() {
        if (this.prev == null) {
            IBSPColChecker.setNodeForActor(this.actor, this.next);
        } else {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
    }
}

