/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import bluej.Config;
import greenfoot.actions.PauseSimulationAction;
import greenfoot.actions.ResetWorldAction;
import greenfoot.actions.RunOnceSimulationAction;
import greenfoot.actions.RunSimulationAction;
import greenfoot.core.Simulation;
import greenfoot.event.SimulationEvent;
import greenfoot.event.SimulationListener;
import greenfoot.util.GreenfootUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends Box
implements ChangeListener,
SimulationListener {
    private RunSimulationAction runSimulationAction;
    private PauseSimulationAction pauseSimulationAction;
    private RunOnceSimulationAction runOnceSimulationAction;
    private ResetWorldAction resetWorldAction;
    private JSlider speedSlider;
    private Simulation simulation;
    private JPanel buttonPanel;
    private JButton pauseButton;
    private JButton runButton;

    public ControlPanel(Simulation simulation, boolean includeAllControls) {
        super(0);
        this.simulation = simulation;
        this.add(this.createButtonPanel(simulation, includeAllControls));
        if (includeAllControls) {
            this.add(this.createSpeedSlider());
        }
        simulation.addSimulationListener(this);
    }

    private JPanel createButtonPanel(Simulation simulation, boolean includeAllControls) {
        this.buttonPanel = new JPanel(new FlowLayout(1, 10, 10));
        if (includeAllControls) {
            this.runOnceSimulationAction = RunOnceSimulationAction.getInstance();
            this.runOnceSimulationAction.attachSimulation(simulation);
            this.runOnceSimulationAction.putValue("LongDescription", Config.getString("controls.runonce.longDescription"));
            this.runOnceSimulationAction.putValue("ShortDescription", Config.getString("controls.runonce.shortDescription"));
            this.runOnceSimulationAction.setEnabled(false);
            JButton stepButton = GreenfootUtil.createButton(this.runOnceSimulationAction);
            this.buttonPanel.add(stepButton);
        }
        this.runSimulationAction = RunSimulationAction.getInstance();
        this.runSimulationAction.attachSimulation(simulation);
        this.runSimulationAction.putValue("LongDescription", Config.getString("controls.run.longDescription"));
        this.runSimulationAction.putValue("ShortDescription", Config.getString("controls.run.shortDescription"));
        this.runSimulationAction.setEnabled(false);
        this.runButton = GreenfootUtil.createButton(this.runSimulationAction);
        this.pauseSimulationAction = PauseSimulationAction.getInstance();
        this.pauseSimulationAction.attachSimulation(simulation);
        this.pauseSimulationAction.putValue("LongDescription", Config.getString("controls.pause.longDescription"));
        this.pauseSimulationAction.putValue("ShortDescription", Config.getString("controls.pause.shortDescription"));
        this.pauseSimulationAction.setEnabled(false);
        this.pauseButton = GreenfootUtil.createButton(this.pauseSimulationAction);
        if (this.pauseButton.getPreferredSize().getWidth() > this.runButton.getPreferredSize().getWidth()) {
            this.runButton.setPreferredSize(this.pauseButton.getPreferredSize());
            this.runButton.setMaximumSize(this.pauseButton.getMaximumSize());
            this.runButton.setMinimumSize(this.pauseButton.getMinimumSize());
        } else {
            this.pauseButton.setPreferredSize(this.runButton.getPreferredSize());
            this.pauseButton.setMaximumSize(this.runButton.getMaximumSize());
            this.pauseButton.setMinimumSize(this.runButton.getMinimumSize());
        }
        this.buttonPanel.add(this.runButton);
        this.resetWorldAction = ResetWorldAction.getInstance();
        this.resetWorldAction.putValue("LongDescription", Config.getString("controls.reset.longDescription"));
        this.resetWorldAction.putValue("ShortDescription", Config.getString("controls.reset.shortDescription"));
        this.resetWorldAction.attachSimulation(simulation);
        this.resetWorldAction.setEnabled(false);
        JButton resetButton = GreenfootUtil.createButton(this.resetWorldAction);
        this.buttonPanel.add(resetButton);
        return this.buttonPanel;
    }

    private JComponent createSpeedSlider() {
        JPanel speedPanel = new JPanel(new FlowLayout());
        JLabel speedLabel = new JLabel(Config.getString("controls.speed.label"));
        speedPanel.add(speedLabel);
        int min = 0;
        int max = 100;
        this.speedSlider = new JSlider(0, min, max, this.simulation.getSpeed());
        this.speedSlider.setPaintLabels(false);
        this.speedSlider.setMajorTickSpacing(max / 2);
        this.speedSlider.setMinorTickSpacing(max / 4);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setEnabled(false);
        this.speedSlider.addChangeListener(this);
        this.speedSlider.setToolTipText(Config.getString("controls.speedSlider.tooltip"));
        this.speedSlider.setFocusable(false);
        speedPanel.add(this.speedSlider);
        return speedPanel;
    }

    @Override
    public void simulationChanged(SimulationEvent e) {
        final int etype = e.getType();
        if (etype == 5 || etype == 6) {
            return;
        }
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                if (etype == 0) {
                    if (ControlPanel.this.speedSlider != null) {
                        ControlPanel.this.speedSlider.setEnabled(true);
                    }
                    ControlPanel.this.buttonPanel.remove(ControlPanel.this.runButton);
                    ControlPanel.this.buttonPanel.add((Component)ControlPanel.this.pauseButton, 1);
                    ControlPanel.this.buttonPanel.validate();
                } else if (etype == 1) {
                    if (ControlPanel.this.speedSlider != null) {
                        ControlPanel.this.speedSlider.setEnabled(true);
                    }
                    ControlPanel.this.buttonPanel.remove(ControlPanel.this.pauseButton);
                    ControlPanel.this.buttonPanel.add((Component)ControlPanel.this.runButton, 1);
                    ControlPanel.this.buttonPanel.validate();
                } else if (etype == 2) {
                    if (ControlPanel.this.speedSlider != null) {
                        ControlPanel.this.speedSlider.setEnabled(true);
                        int newSpeed = ControlPanel.this.simulation.getSpeed();
                        if (newSpeed != ControlPanel.this.speedSlider.getValue()) {
                            ControlPanel.this.speedSlider.setValue(newSpeed);
                        }
                    }
                } else if (etype == 3 && ControlPanel.this.speedSlider != null) {
                    ControlPanel.this.speedSlider.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.simulation.setSpeed(this.speedSlider.getValue());
    }
}

