#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from view import View
from model import Model

class Controller:
    def __init__(self):
        """Creates a Controller-Object that combines View and Model."""
        self.v = View(self._cb_v,self.exit,self.set_speicher,self.get_speicher)
        self.m = Model(self.v.setByte1,self.v.setByte2,self.v.setHalfByte,
                       self.v.setMProw,self.v.setZeroChk,self.v.setTakt,
                       self.v.setLoad,self.v.setEnable,self.v.update,
                       self.v.setUp,self.v.setDown,self.v.speicherstate)
        self.end = 0

    def set_speicher(self,inhalt):
        """Sets the data content of the memory to 'inhalt'.
'inhalt' may be a list of integers and has the length of 256."""
        self.m.setSpeicher(inhalt)
    def get_speicher(self):
        """Returns the data content of the momory.
It'll return a list of integers with the length of 256."""
        return self.m.getSpeicher()
    def _cb_v(self,board,button):
        """Intern use only.
Passes the callback to model.input"""
        self.m.input(board,button)

    def mainloop(self):
        """Starts the mainloop of controller.
Be careful: This function will keep the runtime till the windows are closed!"""
        while not self.end:
            self.v.update()
            self.m.update()
        self.m.quit()

    def exit(self):
        "This function will stop the mainloop of controller."
        self.end = 1

if __name__ == '__main__':
    c = Controller()
    c.mainloop()
