#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from register import Register as Reg

class ZeroCheck(Reg):
    def __init__(self,bus,cb_Zero=None):
        """Creates a "permanent-read"-Register wich is not able to write
with a callback if the value of the bus gets zero
and a boolean variable (isZero) weather the busvalue is zero (True) or not (False)"""
        Reg.__init__(self,'ZeroCheck',bus,cb_Value=self._val)
        self.cb_z = cb_Zero
        self.isZero = False
        self.setLoad(True)
        #del self.setEnable

    def _val(self,name,value):
        """Intern use only.
set the Value of the ZC-Register"""
        assert name == 'ZeroCheck'
        if value == 0:
            self.isZero = True
            if self.cb_z != None:
                self.cb_z(True)
        else:
            self.isZero = False
            if self.cb_z != None:
                self.cb_z(False)

class Decoder(Reg):
    def __init__(self,name,bus,cb_Value=None):
        """Creates a Register that converts a decimal integer to another int.
  input | output
 dec|bin|dec|bin
--------+--------
   0| 00|  3|0011
   1| 01|  7|0111
   2| 10| 11|1011
   3| 11| 12|1100
This register has neither cb_Enable nor cb_Load nor setLoad.
The decimal int must be passed to the setValue function as the "cmd"-parameter.
The register's value will then be the convertet int."""
        Reg.__init__(self,name,bus,cb_Value=cb_Value)
        Reg.setValue(self,3)             #Defaultvalue because 00(00 0000) is the defaultvalue of BR.
        self.setEnable(1)
        #del self.setLoad                #self.__load can't be deleted because it is used in functions like setBus
        
    def setValue(self,cmd):
        "This function will convert cmd (int) and store the output as register's value."
        assert type(cmd) == int and 0 <= cmd <= 3
        if cmd == 0:
            Reg.setValue(self, 3)
        elif cmd == 1:
            Reg.setValue(self, 7)
        elif cmd == 2:
            Reg.setValue(self,11)
        else:
            Reg.setValue(self,12)

            
from register import TwoBusRegister as TBReg

class BR(TBReg):
    def __init__(self,name,databus,addrbus,MPCBus,cb_Zero=None,cb_DecodeVal=None,cb_Enable=None,cb_Load=None,cb_Value=None):
        """Creates a Register that splits the data from the databus into a comand and a adress.
name is a string that will be given back by the callbacks
databus is the bus BR reads from
addrbus is the bus BR "writes" an adress on
cb_Zero is the function that shall be called if the ZeroCheck detects a Zero on the databus
cbDecodeVal is the function that shall be called if the Decoder's output-value changes#
cb_Enable is the function that shall be called when BR starts or stops writing on the addrbus
cb_Load is the function that shall be called when BR starts or stops reading from the databus
cb_Value is the function that shall be called when BR's Value changes""" 
        TBReg.__init__(self,name,databus,addrbus,cb_Load,cb_Enable,cb_Value)
        self.cbZC = cb_Zero
        self.cbDV = cb_DecodeVal
        self.ZC = ZeroCheck(databus,self._cb_Zero)
        self.DC = Decoder('BR_Decoder',MPCBus,self._cb_DecodeVal)

    def _cb_Zero(self,level):
        """Inter use only.
Calls the ZC-Callback."""
        if self.cbZC != None:
            self.cbZC(self.name,level)
    def _cb_DecodeVal(self,name,level):
        """Inter use only.
Calls the DecocerValue-Callback."""
        assert name == 'BR_Decoder'
        if self.cbDV != None:
            self.cbDV(self.name,level)

    def getValue(self):
        "returns the value of the register but without the comandbits"
        return TBReg.getValue(self)&63

    def setValue(self,value):
        "Sets BR's Value to \"value\"."
        self.DC.setValue((value&192)//64 if value != None else 3)
        TBReg.setValue(self,value)
