#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from SwitchCanvas import SwitchCanvas as SC
from tkinter import TclError
import tkinter as tk

z = [23*[0],15*[0],15*[0],15*[0],15*[0],62*[0]]
z[0][8] = 1

class DetailView(tk.Toplevel):
    def __init__(self, cb=None, master=None, cnf={}, **kw):
        """Creates a tk.Toplevel
wich is filled witch a large picture of a Bonsai-board.
The viewed board is easyly exchangeable.
Input:
cb: func - The function that shall be called if any kind of button is used.
parameters of callback: (board,part,level)
while board is the board on which the button is used;
part is the part on the SwitchCanvas that showes the button and
level is a boolean with the logical status of the button."""
        tk.Toplevel.__init__(self,master, cnf, **kw)
        self.cb = cb
        self.geometry('302x452')
        self.resizable(0,0)
        self.title('Bonsai-DetailView')
        self.__z = 'Speicher'
        #Speicher
        self.SC_Speicher = SC('src/detail/Speicher_off.gif','src/detail/Speicher_on.gif',[107, 82,120, 97,    # 0: Adr.-Bus Bit7
                                                                                          119, 82,131, 97,    # 1: Adr.-Bus Bit6
                                                                                          130, 82,142, 97,    # 2: Adr.-Bus Bit5
                                                                                          141, 82,153, 97,    # 3: Adr.-Bus Bit4
                                                                                          152, 82,165, 97,    # 4: Adr.-Bus Bit3
                                                                                          164, 84,176, 99,    # 5: Adr.-Bus Bit2
                                                                                          175, 84,187, 99,    # 6: Adr.-Bus Bit1
                                                                                          186, 84,199, 99,    # 7: Adr.-Bus Bit0
                                                                                          236,167,262,176,    # 8: Jumper 1
                                                                                          236,175,262,182,    # 9: Jumper 2
                                                                                          236,181,262,189,    #10: Jumper 3
                                                                                          242,244,266,261,    #11: LoadLED
                                                                                          242,260,266,279,    #12: EnableLED
                                                                                           59,263, 97,302,    #13: ReadButton
                                                                                           60,306, 98,345,    #14: WriteButton
                                                                                          105,273,121,293,    #15: Data-Bus Bit7
                                                                                          120,273,132,293,    #16: Data-Bus Bit6
                                                                                          131,273,144,293,    #17: Data-Bus Bit5
                                                                                          143,273,155,293,    #18: Data-Bus Bit4
                                                                                          154,273,166,293,    #19: Data-Bus Bit3
                                                                                          165,273,177,293,    #20: Data-Bus Bit2
                                                                                          176,273,188,293,    #21: Data-Bus Bit1
                                                                                          187,273,200,293],   #22: Data-Bus Bit0
                              master=self)
        self.SC_Speicher.part_bind(13,'<Button-1>',self._B1_Press)
        self.SC_Speicher.part_bind(13,'<ButtonRelease-1>',self._B1_Release)
        self.SC_Speicher.part_bind(14,'<Button-1>',self._B2_Press)
        self.SC_Speicher.part_bind(14,'<ButtonRelease-1>',self._B2_Release)
        self.SC_Speicher.part_bind( 8,'<Button-1>',self._J1)
        self.SC_Speicher.part_bind( 9,'<Button-1>',self._J2)
        self.SC_Speicher.part_bind(10,'<Button-1>',self._J3)
        self.SC_Speicher.place(x=1,y=1,anchor='nw')
        #PC
        self.SC_PC = SC('src/detail/PC_off.gif','src/detail/PC_on.gif',[ 72,136, 90,149,    # 0: LoadLED
                                                                         89,136,106,150,    # 1: EnableLED
                                                                        151,148,165,167,    # 2: Bit7LED
                                                                        164,148,176,167,    # 3: Bit6LED
                                                                        175,148,187,167,    # 4: Bit5LED
                                                                        186,148,197,167,    # 5: Bit4LED
                                                                        196,148,208,167,    # 6: Bit3LED
                                                                        207,148,219,167,    # 7: Bit2LED
                                                                        218,148,229,167,    # 8: Bit1LED
                                                                        228,148,240,167,    # 9: Bit0LED
                                                                        201,276,220,290,    #10: UpLED
                                                                        201,290,220,302,    #11: DownLED
                                                                         76,362,109,399,    #12: UpButton
                                                                        114,363,147,400,    #13: DownButton
                                                                        151,362,184,399],   #14: ClrButton
                            master=self)
        self.SC_PC.part_bind(12,'<Button-1>',self._B1_Press)
        self.SC_PC.part_bind(12,'<ButtonRelease-1>',self._B1_Release)
        self.SC_PC.part_bind(13,'<Button-1>',self._B2_Press)
        self.SC_PC.part_bind(13,'<ButtonRelease-1>',self._B2_Release)
        self.SC_PC.part_bind(14,'<Button-1>',self._B3_Press)
        self.SC_PC.part_bind(14,'<ButtonRelease-1>',self._B3_Release)
        #BR
        self.SC_BR = SC('src/detail/BR_off.gif','src/detail/BR_on.gif',[153, 84,168,106,    # 0: Bit7LED
                                                                        167, 84,180,106,    # 1: Bit6LED
                                                                        179, 84,192,106,    # 2: Bit5LED
                                                                        191, 84,204,106,    # 3: Bit4LED
                                                                        203, 84,216,106,    # 4: Bit3LED
                                                                        215, 84,228,106,    # 5: Bit2LED
                                                                        227, 84,239,106,    # 6: Bit1LED
                                                                        238, 84,255,106,    # 7: Bit0LED
                                                                         52,125, 78,147,    # 8: EnableLED
                                                                        140,260,165,280,    # 9: LoadLED
                                                                         20,280, 65,310,    #10: ZeroChkLED
                                                                        175,390,189,430,    #11: DecBit3LED
                                                                        188,390,201,430,    #12: DecBit2LED
                                                                        200,390,213,430,    #13: DecBit1LED
                                                                        212,390,230,430],   #14: DecBit0LED
                            master=self)
        #Akku
        self.SC_Akku = SC('src/detail/Akku_off.gif','src/detail/Akku_on.gif',[ 72,114, 90,131,    # 0: LoadLED
                                                                               90,113,109,132,    # 1: EnableLED
                                                                              157,132,170,144,    # 2: Bit7LED
                                                                              169,132,183,144,    # 3: Bit6LED
                                                                              182,132,194,144,    # 4: Bit5LED
                                                                              193,132,206,144,    # 5: Bit4LED
                                                                              205,132,219,144,    # 6: Bit3LED
                                                                              218,132,230,144,    # 7: Bit2LED
                                                                              229,132,240,145,    # 8: Bit1LED
                                                                              239,132,251,145,    # 9: Bit0LED
                                                                              207,267,231,284,    #10: UpLED
                                                                              207,283,231,300,    #11: DownLED
                                                                               74,359,108,397,    #12: UpButton
                                                                              113,360,147,398,    #13: DownButton
                                                                              153,360,187,398],   #14: ClrButton
                            master=self)
        self.SC_Akku.part_bind(12,'<Button-1>',self._B1_Press)
        self.SC_Akku.part_bind(12,'<ButtonRelease-1>',self._B1_Release)
        self.SC_Akku.part_bind(13,'<Button-1>',self._B2_Press)
        self.SC_Akku.part_bind(13,'<ButtonRelease-1>',self._B2_Release)
        self.SC_Akku.part_bind(14,'<Button-1>',self._B3_Press)
        self.SC_Akku.part_bind(14,'<ButtonRelease-1>',self._B3_Release)
        #HS
        self.SC_HS = SC('src/detail/HS_off.gif','src/detail/HS_on.gif',[169,136,188,154,    # 0: EnableLED
                                                                         54,171, 73,196,    # 1: InputBit7
                                                                         78,171, 96,196,    # 2: InputBit6
                                                                        101,172,119,197,    # 3: InputBit5
                                                                        125,172,143,197,    # 4: InputBit4
                                                                        149,172,166,198,    # 5: InputBit3
                                                                        172,172,190,198,    # 6: InputBit2
                                                                        195,172,213,198,    # 7: InputBit1
                                                                        218,172,236,198,    # 8: InputBit0
                                                                        220,197,243,218,    # 9: TaktLED
                                                                         36,246, 55,270,    #10: SwitchSchnell
                                                                         36,293, 55,318,    #11: SwitchDauer
                                                                         64,287, 98,325,    #12: ButtonTakt
                                                                        200,297,227,316,    #13: SwitchHand
                                                                         63,352, 97,399],   #14: ButtonReset
                            master=self)
        self.SC_HS.part_bind(12,'<Button-1>',self._B1_Press)
        self.SC_HS.part_bind(12,'<ButtonRelease-1>',self._B1_Release)
        self.SC_HS.part_bind(14,'<Button-1>',self._B2_Press)
        self.SC_HS.part_bind(14,'<ButtonRelease-1>',self._B2_Release)
        for i in tuple(range(1,9))+(10,11,13):
            self.SC_HS.part_bind(i,'<Button-1>',self._KS)
        #SW
        self.SC_SW = SC('src/detail/SW_off.gif','src/detail/SW_on.gif',[150, 65,170, 90,    # 0: EnableLED
                                                                        202,124,211,132,    # 1: MP Z 1LED1
                                                                        143,130,152,138,    # 2: MP Z 2LED1
                                                                        202,131,210,138,    # 3: MP Z 2LED2
                                                                        209,130,218,139,    # 4: MP Z 2LED3
                                                                        134,136,146,144,    # 5: MP Z 3LED1
                                                                        137,137,153,145,    # 6: MP Z 3LED2
                                                                        202,137,211,145,    # 7: MP Z 3LED3
                                                                        215,142,224,150,    # 8: MP Z 4LED1
                                                                        143,148,151,156,    # 9: MP Z 5LED1
                                                                        167,147,176,156,    #10: MP Z 5LED2
                                                                        215,149,223,156,    #11: MP Z 5LED3
                                                                        155,154,162,162,    #12: MP Z 6LED1
                                                                        214,155,222,162,    #13: MP Z 6LED2
                                                                        221,154,230,163,    #14: MP Z 6LED3
                                                                        131,159,139,168,    #15: MP Z 7LED1
                                                                        149,160,157,168,    #16: MP Z 7LED2
                                                                        173,160,182,169,    #17: MP Z 7LED3
                                                                        214,161,222,168,    #18: MP Z 7LED4
                                                                        214,167,222,179,    #19: MP Z 8LED1
                                                                        144,183,152,192,    #20: MP Z 9LED1
                                                                        167,183,175,192,    #21: MP Z 9LED2
                                                                        214,184,223,192,    #22: MP Z 9LED3
                                                                        161,189,167,196,    #23: MP Z10LED1
                                                                        213,191,221,198,    #24: MP Z10LED2
                                                                        220,190,227,198,    #25: MP Z10LED3
                                                                        133,194,141,202,    #26: MP Z11LED1
                                                                        149,196,156,202,    #27: MP Z11LED2
                                                                        172,194,181,203,    #28: MP Z11LED3
                                                                        213,197,221,204,    #29: MP Z11LED4
                                                                        131,201,140,209,    #30: MP Z12LED1
                                                                        196,202,204,210,    #31: MP Z12LED2
                                                                        213,203,221,210,    #32: MP Z12LED3
                                                                        213,209,221,216,    #33: MP Z13LED1
                                                                        143,213,150,220,    #34: MP Z14LED1
                                                                        214,215,222,222,    #35: MP Z14LED2
                                                                        221,215,229,223,    #36: MP Z14LED3
                                                                        132,219,139,226,    #37: MP Z15LED1
                                                                        140,219,147,226,    #38: MP Z15LED2
                                                                        213,221,222,229,    #39: MP Z15LED3
                                                                        226,221,234,229,    #40: MP Z15LED4
                                                                         42,298, 56,313,    #41: MPC3LED
                                                                         55,298, 68,313,    #42: MPC2LED
                                                                         67,298, 80,313,    #43: MPC1LED
                                                                         79,298, 93,313,    #44: MPC0LED
                                                                        104,298,122,316,    #45: EnableLED
                                                                         46,373, 59,387,    #46: LED15CS
                                                                         58,373, 71,387,    #47: LED14CS
                                                                         70,373, 84,400,    #48: LED13CS
                                                                         83,373, 96,400,    #49: LED12CS
                                                                         95,373,107,400,    #50: LED11CS
                                                                        106,373,119,400,    #51: LED10CS
                                                                        118,373,131,400,    #52: LED 9CS
                                                                        130,373,143,400,    #53: LED 8CS
                                                                        142,373,155,400,    #54: LED 7CS
                                                                        154,373,166,400,    #55: LED 6CS
                                                                        165,373,178,400,    #56: LED 5CS
                                                                        177,373,189,400,    #57: LED 4CS
                                                                        188,373,201,400,    #58: LED 3CS
                                                                        200,373,212,400,    #59: LED 2CS
                                                                        211,373,224,400,    #60: LED 1CS
                                                                        223,373,236,400],   #61: LED 0CS
                            master=self)
            
        self.SCs = [self.SC_Speicher,self.SC_PC,self.SC_BR,self.SC_Akku,self.SC_HS,self.SC_SW]
        
        global z
        for i1 in range(5):
            for i2 in range(len(z[i1])):
                self.set(i1,i2,z[i1][i2])
        self.__z_J = 1*z[0][8]+2**z[0][9]+3*z[0][10]

    def set(self,board,part,level):
        """Set a part of a board to a level
board is the board on which the part is;
part is the part on the SwitchCanvas that showes the thing to change and
level is a boolean with the logical status of the object."""
        try:
            if level: self.SCs[board].setOn(part)
            else:     self.SCs[board].setOff(part)
        except TclError: pass
        global z
        z[board][part] = level
        
    def _KS(self,event):
        """Intern function.
_KS wird aufgerufen, wenn ein Kippschalter der HS getätigt wird"""
        self.SC_HS.toggle(event.widget.id)
        global z
        z[4][event.widget.id] = not z[4][event.widget.id]
        if self.cb != None: self.cb(4,event.widget.id,z[4][event.widget.id])
    def _J1(self,event):
        """Intern function.
_J1 wird aufgerufen, wenn der obere Jumper des Speichers geklickt wird."""
        assert self.__z == 'Speicher'
        if self.__z_J != 1:
            self.__z_J = 1
            self.SC_Speicher.setOn ( 8)
            if self.cb != None: self.cb(0, 8,1)
            self.SC_Speicher.setOff( 9)
            if self.cb != None: self.cb(0, 9,0)
            self.SC_Speicher.setOff(10)
            if self.cb != None: self.cb(0,10,0)
    def _J2(self,event):
        """Intern function.
_J2 wird aufgerufen, wenn der mittlere Jumper des Speichers geklickt wird."""
        if self.__z_J != 2:
            self.__z_J = 2
            assert self.__z == 'Speicher'
            self.SC_Speicher.setOff( 8)
            if self.cb != None: self.cb(0, 8,0)
            self.SC_Speicher.setOn ( 9)
            if self.cb != None: self.cb(0, 9,1)
            self.SC_Speicher.setOff(10)
            if self.cb != None: self.cb(0,10,0)
    def _J3(self,event):
        """Intern function.
_J3 wird aufgerufen, wenn der untere Jumper des Speichers geklickt wird."""
        if self.__z_J != 3:
            self.__z_J = 3
            assert self.__z == 'Speicher'
            self.SC_Speicher.setOff( 8)
            if self.cb != None: self.cb(0, 8,0)
            self.SC_Speicher.setOff( 9)
            if self.cb != None: self.cb(0, 9,0)
            self.SC_Speicher.setOn (10)
            if self.cb != None: self.cb(0,10,1)

    def _B1_Press(self,event):
        """Intern function.
_B1_Press wird aufgerufen, wenn der 1. Taster einer Platine gedrückt wird."""
        assert self.__z in ('Speicher','PC','Akku','HS')
        if self.__z in ('PC','Akku'):
            exec('self.SC_'+self.__z+'.setOn(10)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,10,1)
            exec('self.SC_'+self.__z+'.setOn(12)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,12,1)
        if self.__z == 'Speicher':
            self.SC_Speicher.setOn(13)
            if self.cb != None: self.cb(0,13,1)
        if self.__z == 'HS':
            self.SC_HS.setOn(12)
            if self.cb != None: self.cb(4,12,1)
    def _B1_Release(self,event):
        """Intern function.
_B1_Release wird aufgerufen, wenn der 1. Taster einer Platine losgelassen wird."""
        assert self.__z in ('Speicher','PC','Akku','HS')
        if self.__z in ('PC','Akku'):
            exec('self.SC_'+self.__z+'.setOff(10)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,10,0)
            exec('self.SC_'+self.__z+'.setOff(12)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,12,0)
        if self.__z == 'Speicher':
            self.SC_Speicher.setOff(13)
            if self.cb != None: self.cb(0,13,0)
        if self.__z == 'HS':
            self.SC_HS.setOff(12)
            if self.cb != None: self.cb(4,12,0)
    def _B2_Press(self,event):
        """Intern function.
_B2_Press wird aufgerufen, wenn der 2. Taster einer Platine gedrückt wird."""
        assert self.__z in ('Speicher','PC','Akku','HS')
        if self.__z in ('PC','Akku'):
            exec('self.SC_'+self.__z+'.setOn(11)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,11,1)
            exec('self.SC_'+self.__z+'.setOn(13)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,13,1)
        if self.__z == 'Speicher':
            self.SC_Speicher.setOn(14)
            if self.cb != None: self.cb(0,14,1)
        if self.__z == 'HS':
            self.SC_HS.setOn(14)
            if self.cb != None: self.cb(4,14,1)
    def _B2_Release(self,event):
        """Intern function.
_B2_Release wird aufgerufen, wenn der 2. Taster einer Platine losgelassen wird."""
        assert self.__z in ('Speicher','PC','Akku','HS')
        if self.__z in ('PC','Akku'):
            exec('self.SC_'+self.__z+'.setOff(11)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,11,0)
            exec('self.SC_'+self.__z+'.setOff(13)')
            if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,13,0)
        if self.__z == 'Speicher':
            self.SC_Speicher.setOff(14)
            if self.cb != None: self.cb(0,14,0)
        if self.__z == 'HS':
            self.SC_HS.setOff(14)
            if self.cb != None: self.cb(4,14,0)
    def _B3_Press(self,event):
        """Intern function.
_B3_Press wird aufgerufen, wenn der 3. Taster einer Platine gedrückt wird."""
        assert self.__z in ('PC','Akku')
        exec('self.SC_'+self.__z+'.setOn(14)')
        if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,14,1)
    def _B3_Release(self,event):
        """Intern function.
_B13Release wird aufgerufen, wenn der 3. Taster einer Platine losgelassen wird."""
        assert self.__z in ('PC','Akku')
        exec('self.SC_'+self.__z+'.setOff(14)')
        if self.cb != None: self.cb(1 if self.__z == 'PC' else 3,14,0)

    def show(self,board):
        """Make DetailView show an other board.
bord: int - Between 0 and 5:
      0 for 'Speicher', 1 for 'PC', 2 for 'BR',
      3 for 'Akku'    , 4 for 'HS', 5 for 'SW'."""
        assert type(board) == int and 0 <= board <= 5
        board = ('Speicher','PC','BR','Akku','HS','SW')[board]
        exec('self.SC_'+self.__z+'.place_forget()')
        exec('self.SC_'+board+'.place(x=1,y=1,anchor=\'nw\')')
        self.__z = board
        self.update_idletasks()


if __name__ == '__main__':
    root = tk.Tk()
    dv = DetailView(print,master=root)
    root.mainloop()
