#Facharbeit
#Created by:
# ____   ___ ___ ____     ________   ___
#/    \ /   \| | \| |     / /__|  \  | |
#| [] |/  _  | |  | |    / /|_ | | \ | |
#|   < | |_| | |  | |\  / / __|| |\ \| |
#| |\ \\     | \__/ | \/ /| |__| | \ | |
#|_| \_\\___/ \___ / \__/ |_____]|  \__| Bauer
#>>>>><<<<<>>>>><<<<<>>>>><<<<<>>>>><<<<
#+++++++++++++++++++++++++++++++++++++++      by d'Guschdl-arts
#Copyright 2010 Rouven Bauer
#    This file is part of "BonSim - The Bonsai Simulation".
#
#    "BonSim - The Bonsai Simulation" is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    "BonSim - The Bonsai Simulation" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "BonSim - the Bonsai-Simulation".  If not, see <http://www.gnu.org/licenses/>.

from register import Register as Reg

class Speicher:
    def __init__(self,name,adrbus,databus,cb_Load=None,cb_Enable=None,cb_Adresse=None,cb_Value=None):
        """Construcs a memory with
name is a string that will be given back by the callbacks
adrbus is the bus from which the memory can read the address from
databus is the bus which the register can \'write\' the value of the cell described by addressbus' value on
cb_Load is the function that shall be called when the memory starts or stops reading from the bus
cb_Enable is the function that shall be called when the memory starts or stops \'writing\' on the bus
cb_Adresse is the function that shall be called when the value of the ADDRESS-BUS changes !NOT MEMORYS VALUE!
cb_Value is the function that shall be called when the value of the DATA-BUS changes !NOT MEMORYS VALUE!
All callback-parameters may be None if you don't want any functions to be called."""
        self.name = name
        self.__load = 0
        self.__enable = 0
        self.__hand = 1
        self.cb_e = cb_Enable
        self.cb_l = cb_Load
        self.cb_a = cb_Adresse
        self.cb_v = cb_Value
        self.__speicher = [[0]*256]*3
        self.pin = 0
        self.__adress = Reg('Speicher_Adress_Reg',adrbus,cb_Value=self._setAdress)
        self.__adress.setLoad(1)
        self.__value = Reg('Speicher_Data_Reg',databus,cb_Value=self._setValue)
        self.__value.setLoad(1)

    def get(self):
        """Return the data content of the memory addressed by the slelected pin/jumper.
It'll return a list of integers with the length of 256."""
        return self.__speicher[self.pin][:]
    def set(self,inhalt):
        """Sets the data content of the memory addressed by the slelected pin/jumper to 'inhalt'.
'inhalt' may be a list of integers and has the length of 256."""
        assert type(inhalt) == list
        assert len(inhalt) == 256
        for i in inhalt:
            if not (type(i) == int and 0<=i<=255):
                raise TypeError(str(i)+'@'+str(inhalt.index(i))+' is no valid memory contense')
        self.__speicher[self.pin] = inhalt

    def setHand(self,level):
        "If level == \"True\" the buttons are enabled if it's \"False\" they are disabled"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if not level:
            self.setLoad(0)
            self.setEnable(0)
        self.__hand = level

    def setLoad(self,level,fromUsr=True):
        "If level = True the 'Speicher' will load the value of the bus to current adress"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self.__hand or not fromUsr:
            self.__load = level
            if level:
                self.__speicher[self.pin][self.__adress.getValue()] = self.__value.getValue()
            if self.cb_l != None: self.cb_l(self.name,level)
    def setEnable(self,level,fromUsr=True):
        "If level = True the 'Speicher' will write the value of the current adress on the bus"
        assert type(level) == bool or type(level) == int and level in (0,1)
        if self.__hand or not fromUsr:
            self.__enable = level
            if level:
                self.__value.setLoad(0)
                self.__value.setValue(self.__speicher[self.pin][self.__adress.getValue()])
                self.__value.setEnable(1)
            else:
                self.__value.setEnable(0)
                self.__value.setLoad(1)
            if self.cb_e != None: self.cb_e(self.name,level)

    def setPin(self,num):
        """Set the Jumpers that way, that section "num" of the memory is read.
The memory contains 3 sections wich are independet.
Therefor "num" must be an integer between 0 and 2"""
        assert type(num) == int and 0 <= num <= 2
        self.pin = num        

    def _setValue(self,name,value):
        """Intern use only.
Handles the cb_Value of self.__adress (register)."""
        assert type(value)==int and 0<=value<=255
        if self.__load:
            self.__speicher[self.pin][self.__adress.getValue()] = value
        if self.cb_v != None: self.cb_v(self.name,value)

    def _setAdress(self,name,value):#
        """Intern use only.
Handles the cb_Value of self.__value (register)."""
        assert type(value)==int and 0<=value<=255
        self.__adress.setValue(value)
        if self.__enable:
            self.__value.setValue(self.__speicher[self.pin][value])
        if self.cb_a != None: self.cb_a(self.name,value)
            
from bus import Bus
if __name__ == '__main__':
    s = Speicher('Dummy-Speicher',Bus('adr'),Bus('data'),print,print)
